/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.core.search.SearchMode;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public final class IngredientGridTooltipHelper {
    private final IIngredientManager ingredientManager;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IClientToggleState toggleState;
    private final IModIdHelper modIdHelper;
    private final IInternalKeyMappings keyBindings;
    private final IColorHelper colorHelper;

    public IngredientGridTooltipHelper(IIngredientManager ingredientManager, IIngredientFilterConfig ingredientFilterConfig, IClientToggleState toggleState, IModIdHelper modIdHelper, IInternalKeyMappings keyBindings, IColorHelper colorHelper) {
        this.ingredientManager = ingredientManager;
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.toggleState = toggleState;
        this.modIdHelper = modIdHelper;
        this.keyBindings = keyBindings;
        this.colorHelper = colorHelper;
    }

    public <T> void drawTooltip(class_332 guiGraphics, int mouseX, int mouseY, ITypedIngredient<T> value) {
        IIngredientType<T> ingredientType = value.getType();
        IIngredientRenderer<T> ingredientRenderer = this.ingredientManager.getIngredientRenderer(ingredientType);
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        List<class_2561> tooltip = this.getTooltip(value, ingredientRenderer, ingredientHelper);
        TooltipRenderer.drawHoveringText(guiGraphics, tooltip, mouseX, mouseY, value, ingredientRenderer, this.ingredientManager);
    }

    public <T> List<class_2561> getTooltip(ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper) {
        List<class_2561> tooltip = SafeIngredientUtil.getTooltip(this.ingredientManager, ingredientRenderer, typedIngredient);
        tooltip = this.modIdHelper.addModNameToIngredientTooltip(tooltip, typedIngredient.getIngredient(), ingredientHelper);
        if (this.ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            this.addColorSearchInfoToTooltip(tooltip, typedIngredient, ingredientHelper);
        }
        if (this.toggleState.isEditModeEnabled()) {
            IngredientGridTooltipHelper.addEditModeInfoToTooltip(tooltip, this.keyBindings);
        }
        return tooltip;
    }

    private <T> void addColorSearchInfoToTooltip(List<class_2561> tooltip, ITypedIngredient<T> typedIngredient, IIngredientHelper<T> ingredientHelper) {
        Iterable<Integer> colors = ingredientHelper.getColors(typedIngredient.getIngredient());
        String colorNamesString = StreamSupport.stream(colors.spliterator(), false).map(this.colorHelper::getClosestColorName).collect(Collectors.joining(", "));
        if (!colorNamesString.isEmpty()) {
            class_5250 colorTranslation = class_2561.method_43469((String)"jei.tooltip.item.colors", (Object[])new Object[]{colorNamesString}).method_27692(class_124.field_1080);
            tooltip.add((class_2561)colorTranslation);
        }
    }

    private static void addEditModeInfoToTooltip(List<class_2561> tooltip, IInternalKeyMappings keyBindings) {
        List<class_5250> lines = List.of(class_5244.field_39003, class_2561.method_43471((String)"gui.jei.editMode.description").method_27692(class_124.field_1077), class_2561.method_43469((String)"gui.jei.editMode.description.hide", (Object[])new Object[]{keyBindings.getToggleHideIngredient().getTranslatedKeyMessage()}).method_27692(class_124.field_1080), class_2561.method_43469((String)"gui.jei.editMode.description.hide.wild", (Object[])new Object[]{keyBindings.getToggleWildcardHideIngredient().getTranslatedKeyMessage()}).method_27692(class_124.field_1080));
        tooltip.addAll(lines);
    }
}

