/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.module;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.Module;
import com.hrznstudio.titanium.module.api.IAlternativeEntries;
import com.hrznstudio.titanium.module.api.RegistryManager;
import com.hrznstudio.titanium.util.SidedHandler;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Feature {
    private final String id;
    private final Map<Class<? extends IForgeRegistryEntry<?>>, List<?>> content;
    private final List<EventManager.ISubscribe> events;
    private final boolean forced;
    private final boolean enabledByDefault;
    private final String description;
    private Module module;

    private Feature(String id, Map<Class<? extends IForgeRegistryEntry<?>>, List<?>> content, List<EventManager.ISubscribe> events, boolean forced, boolean enabledByDefault, String description) {
        this.id = id;
        this.content = content;
        this.events = events;
        this.forced = forced;
        this.enabledByDefault = enabledByDefault;
        this.description = description;
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public Module getModule() {
        return this.module;
    }

    Feature setModule(Module module) {
        this.module = module;
        return this;
    }

    public Map<Class<? extends IForgeRegistryEntry<?>>, List<?>> getContent() {
        return this.content;
    }

    public boolean isForced() {
        return this.forced;
    }

    public String getId() {
        return this.id;
    }

    protected void initConfig(String prefix, CommentedFileConfig config) {
    }

    public void initEvents() {
        this.events.forEach(EventManager.ISubscribe::subscribe);
    }

    public <T extends IForgeRegistryEntry<T>> List<? extends T> getEntries(Class<T> tClass) {
        return this.content.computeIfAbsent(tClass, aClass -> new LinkedList());
    }

    public static final class Builder
    implements RegistryManager<Builder> {
        private final String id;
        private final Map<Class<? extends IForgeRegistryEntry<?>>, List<?>> content = new LinkedHashMap();
        private final List<EventManager.ISubscribe> events = new LinkedList<EventManager.ISubscribe>();
        private boolean forced;
        private boolean enabledByDefault = true;
        private String description;

        private Builder(String id) {
            this.id = id;
        }

        @Override
        public <T extends IForgeRegistryEntry<T>> Builder content(Class<T> tClass, T t) {
            this.getList(tClass).add(t);
            if (t instanceof IAlternativeEntries) {
                ((IAlternativeEntries)t).addAlternatives(this);
            }
            return this;
        }

        public Builder event(EventManager.ISubscribe manager) {
            this.events.add(manager);
            return this;
        }

        public Builder eventClient(Supplier<Supplier<EventManager.ISubscribe>> managerSupplier) {
            SidedHandler.runOn(Dist.CLIENT, () -> () -> this.lambda$null$0((Supplier)managerSupplier));
            return this;
        }

        public Builder force() {
            this.forced = true;
            return this;
        }

        public Builder description(String s) {
            this.description = s;
            return this;
        }

        public Builder disableByDefault() {
            this.enabledByDefault = false;
            return this;
        }

        public <T extends IForgeRegistryEntry<T>> List<T> getList(Class<T> tClass) {
            return this.content.computeIfAbsent(tClass, aClass -> new LinkedList());
        }

        public Feature build() {
            return new Feature(this.id, this.content, this.events, this.forced, this.enabledByDefault, this.description);
        }

        private /* synthetic */ void lambda$null$0(Supplier managerSupplier) {
            this.events.add((EventManager.ISubscribe)((Supplier)managerSupplier.get()).get());
        }
    }
}

