/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.api;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import org.apache.commons.lang3.ArrayUtils;

@FunctionalInterface
public interface IItemStackQuery
extends Predicate<ItemStack> {
    public static final IItemStackQuery ANYTHING = stack -> true;
    public static final IItemStackQuery NOTHING = stack -> false;

    public static IItemStackQuery of(Item item) {
        return new ItemQuery(item);
    }

    public static IItemStackQuery of(ItemStack stack) {
        return new ItemStackQuery(stack);
    }

    public static IItemStackQuery of(Block block) {
        return IItemStackQuery.of(block.func_199767_j());
    }

    public boolean matches(ItemStack var1);

    @Override
    default public boolean test(ItemStack stack) {
        return this.matches(stack);
    }

    default public BiPredicate<ItemStack, Integer> toSlotFilter(int ... slots) {
        return this.toSlotFilter(slot -> ArrayUtils.contains((int[])slots, (int)slot));
    }

    default public BiPredicate<ItemStack, Integer> toSlotFilter(Predicate<Integer> slotPredicate) {
        return (stack, slot) -> slotPredicate.test((Integer)slot) && this.test((ItemStack)stack);
    }

    default public BiPredicate<ItemStack, Integer> toSlotFilter(int min, int max) {
        return this.toSlotFilter(slot -> slot >= min && slot <= max);
    }

    default public BiPredicate<ItemStack, Integer> toSlotFilter() {
        return this.toSlotFilter(slot -> true);
    }

    public static class IngredientQuery
    implements IItemStackQueryRecipe {
        protected Ingredient ingredient;

        public IngredientQuery(Ingredient ingredient) {
            this.ingredient = ingredient;
        }

        @Override
        public ItemStack[] getMatchingStacks() {
            return this.ingredient.func_193365_a();
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return this.ingredient.test(itemStack);
        }
    }

    public static class ItemQuery
    implements IItemStackQueryRecipe {
        protected Item item;

        public ItemQuery(Item item) {
            this.item = item;
        }

        public Item getItem() {
            return this.item;
        }

        @Override
        public ItemStack[] getMatchingStacks() {
            return new ItemStack[]{new ItemStack((IItemProvider)this.item)};
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return itemStack.func_77973_b().equals(this.item);
        }
    }

    public static class ItemStackQuery
    implements IItemStackQueryRecipe {
        protected ItemStack stack;

        public ItemStackQuery(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean matches(ItemStack stack) {
            return ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)stack);
        }

        @Override
        public ItemStack[] getMatchingStacks() {
            return new ItemStack[]{this.stack};
        }
    }

    @FunctionalInterface
    public static interface IItemStackNBTQuery
    extends IItemStackQuery {
        @Override
        default public boolean matches(ItemStack itemStack) {
            return itemStack.func_77942_o() && this.matches(itemStack.func_77978_p());
        }

        public boolean matches(CompoundNBT var1);
    }

    public static interface IItemStackQueryRecipe
    extends IItemStackQuery {
        public ItemStack[] getMatchingStacks();
    }
}

