/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jade;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.CokeOvenLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.SheetmetalTankLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.JadeForgeUtils;

public class MultiblockTankDataProvider<T extends IMultiblockState>
implements IServerExtensionProvider<IMultiblockBE<T>, CompoundTag>,
IClientExtensionProvider<CompoundTag, FluidView> {
    @Nullable
    public List<ViewGroup<CompoundTag>> getGroups(ServerPlayer serverPlayer, ServerLevel serverLevel, IMultiblockBE<T> multiblockBE, boolean b) {
        IMultiblockBEHelper<T> helper = multiblockBE.getHelper();
        T t = helper.getState();
        if (t instanceof ProcessContext) {
            ProcessContext state = (ProcessContext)t;
            if (state.getInternalTanks().length > 0) {
                ArrayList<CompoundTag> list = new ArrayList<CompoundTag>();
                for (int i = 0; i < state.getInternalTanks().length; ++i) {
                    FluidStack fluid = state.getInternalTanks()[i].getFluid();
                    long capacity = state.getInternalTanks()[i].getCapacity();
                    list.add(JadeForgeUtils.fromFluidStack((FluidStack)fluid, (long)capacity));
                }
                return List.of(new ViewGroup(list));
            }
        } else {
            t = helper.getState();
            if (t instanceof SheetmetalTankLogic.State) {
                SheetmetalTankLogic.State state = (SheetmetalTankLogic.State)t;
                return JadeForgeUtils.fromFluidHandler((IFluidHandler)state.tank);
            }
            t = helper.getState();
            if (t instanceof CokeOvenLogic.State) {
                CokeOvenLogic.State state = (CokeOvenLogic.State)t;
                return JadeForgeUtils.fromFluidHandler((IFluidHandler)state.getTank());
            }
        }
        return null;
    }

    public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> list) {
        return ClientViewGroup.map(list, FluidView::readDefault, null);
    }

    public ResourceLocation getUid() {
        return ImmersiveEngineering.rl("multiblock_tank");
    }
}

