/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.WireDamageHandler;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.network.MessagePowerpackAntenna;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemGetterList;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.PacketDistributor;

public class PowerpackItem
extends UpgradeableToolItem {
    private static final Supplier<Map<Item, IEServerConfig.Machines.CapacitorConfig>> capacitorConfigMap = Suppliers.memoize(() -> {
        HashMap<Item, IEServerConfig.Machines.CapacitorConfig> capacitorConfigMap = new HashMap<Item, IEServerConfig.Machines.CapacitorConfig>();
        capacitorConfigMap.put(IEBlocks.MetalDevices.CAPACITOR_LV.m_5456_(), IEServerConfig.MACHINES.lvCapConfig);
        capacitorConfigMap.put(IEBlocks.MetalDevices.CAPACITOR_MV.m_5456_(), IEServerConfig.MACHINES.mvCapConfig);
        capacitorConfigMap.put(IEBlocks.MetalDevices.CAPACITOR_HV.m_5456_(), IEServerConfig.MACHINES.hvCapConfig);
        capacitorConfigMap.put(IEBlocks.MetalDevices.CAPACITOR_CREATIVE.m_5456_(), IEServerConfig.Machines.CapacitorConfig.CREATIVE);
        return capacitorConfigMap;
    });
    private static final Map<UUID, Connection> PLAYER_ATTACHED_TO = new HashMap<UUID, Connection>();
    public static final ItemGetterList POWERPACK_GETTER = new ItemGetterList(player -> {
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (chest.m_41720_() instanceof PowerpackItem) {
            return chest;
        }
        if (ItemNBTHelper.hasKey(chest, "IE:Powerpack")) {
            return ItemNBTHelper.getItemStack(chest, "IE:Powerpack");
        }
        return ItemStack.f_41583_;
    });
    public static final int ITEM_CHARGE_RATE = 256;
    public static final int INDUCTION_CHARGE_RATE = 8;
    public static final int ANTENNA_CHARGE_RATE = 32;
    public static final int TESLA_CONSUMPTION = 1024;
    public static final int MAGNET_CONSUMPTION = 8;

    public PowerpackItem() {
        super(new Item.Properties().m_41487_(1), "POWERPACK");
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        IEnergyStorage energy = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
        if (energy != null) {
            String stored = energy.getEnergyStored() + "/" + PowerpackItem.getMaxEnergyStored(stack);
            list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        EquipmentSlot slot = Mob.m_147233_((ItemStack)heldItem);
        if (!player.m_6844_(slot).m_41619_()) {
            return InteractionResultHolder.m_19100_((Object)heldItem);
        }
        player.m_8061_(slot, heldItem.m_41777_());
        if (!world.m_5776_()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        heldItem.m_41764_(0);
        return InteractionResultHolder.m_19092_((Object)heldItem, (boolean)world.m_5776_());
    }

    public void onArmorTick(ItemStack itemStack, Level world, Player player) {
        int energy = EnergyHelper.getEnergyStored((ICapabilityProvider)itemStack);
        if (energy > 0) {
            int pre = energy;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack equipped = player.m_6844_(slot);
                if (!EnergyHelper.isFluxReceiver((ICapabilityProvider)equipped) || equipped.m_41720_() instanceof PowerpackItem || equipped.m_41720_() instanceof BlockItem) continue;
                energy -= EnergyHelper.insertFlux((ICapabilityProvider)equipped, Math.min(energy, 256), false);
            }
            if (this.getUpgrades(itemStack).m_128471_("induction") && player.f_19797_ % 4 == 0) {
                NonNullList allItems = player.m_150109_().f_35974_;
                int selected = player.m_150109_().f_35977_;
                for (int i = 0; i < allItems.size(); ++i) {
                    if (i == selected) continue;
                    ItemStack inventoryItem = (ItemStack)allItems.get(i);
                    if (EnergyHelper.isFluxReceiver((ICapabilityProvider)inventoryItem) && !(inventoryItem.m_41720_() instanceof PowerpackItem) && !(inventoryItem.m_41720_() instanceof BlockItem)) {
                        energy -= EnergyHelper.insertFlux((ICapabilityProvider)inventoryItem, Math.min(energy, 8), false);
                    }
                    if (energy <= 0) break;
                }
            }
            if (pre != energy) {
                EnergyHelper.extractFlux((ICapabilityProvider)itemStack, pre - energy, false);
            }
        }
        if (this.getUpgrades(itemStack).m_128471_("antenna")) {
            this.handleAntennaTick(itemStack, world, player);
        }
        if (this.getUpgrades(itemStack).m_128471_("magnet") && energy >= 8) {
            this.handleMagnetTick(itemStack, world, player);
        }
    }

    private void handleAntennaTick(ItemStack itemStack, Level world, Player player) {
        AbstractMinecart minecart;
        BlockPos railPos;
        Entity entity;
        boolean grounded = player.m_20201_().m_20096_();
        if (!grounded && (entity = player.m_20201_()) instanceof AbstractMinecart && world.m_8055_(railPos = (minecart = (AbstractMinecart)entity).getCurrentRailPosition()).m_204336_(BlockTags.f_13034_)) {
            grounded = true;
        }
        if (!grounded || world.m_5776_()) {
            return;
        }
        GlobalWireNetwork global = GlobalWireNetwork.getNetwork(world);
        if (PLAYER_ATTACHED_TO.containsKey(player.m_20148_())) {
            Connection conn2 = PLAYER_ATTACHED_TO.get(player.m_20148_());
            Connection.CatenaryData catenary = conn2.getCatenaryData();
            Vec3 antennaTip = player.m_20182_().m_82520_(0.0, 2.5, 0.0);
            Vec3 ap = antennaTip.m_82546_(Vec3.m_82528_((Vec3i)conn2.getEndA().position()).m_82549_(conn2.getEndAOffset()));
            double orthLength = ap.m_82526_(catenary.delta()) / catenary.delta().m_82526_(catenary.delta());
            Vec3 catPoint = conn2.getPoint(orthLength, conn2.getEndA()).m_82549_(Vec3.m_82528_((Vec3i)conn2.getEndA().position()));
            double dist = antennaTip.m_82546_(catPoint).m_82556_();
            if (orthLength < 0.0 || orthLength > 1.0 || dist >= 8.0) {
                PLAYER_ATTACHED_TO.remove(player.m_20148_());
                ImmersiveEngineering.packetHandler.send(PacketDistributor.ALL.noArg(), (Object)new MessagePowerpackAntenna(player, null));
            } else if (!world.m_5776_()) {
                this.findBestSource(global, conn2).ifPresent(e -> {
                    int charge = Math.min(e.getAvailableEnergy(), 32);
                    charge = EnergyHelper.insertFlux((ICapabilityProvider)itemStack, charge, false);
                    e.extractEnergy(charge);
                });
            }
        } else {
            WireCollisionData wireData = global.getCollisionData();
            Collection<WireCollisionData.CollisionInfo> atBlock = wireData.getCollisionInfo(player.m_20097_().m_6630_(4));
            Optional<Connection> connection = atBlock.stream().filter(WireCollisionData.CollisionInfo::isInBlock).map(WireCollisionData.CollisionInfo::connection).filter(c -> c.type instanceof WireDamageHandler.IShockingWire).filter(c -> {
                Vec3 delta = c.getCatenaryData().delta();
                double angle = c.getCatenaryData().isVertical() ? 1.0 : delta.m_7098_() / Math.sqrt(delta.m_7096_() * delta.m_7096_() + delta.m_7094_() * delta.m_7094_());
                return Math.abs(angle) < 0.5;
            }).findAny();
            connection.ifPresent(conn -> {
                AbstractMinecart minecart;
                PLAYER_ATTACHED_TO.put(player.m_20148_(), (Connection)conn);
                ImmersiveEngineering.packetHandler.send(PacketDistributor.ALL.noArg(), (Object)new MessagePowerpackAntenna(player, (Connection)conn));
                Entity patt9972$temp = player.m_20202_();
                if (patt9972$temp instanceof AbstractMinecart && (minecart = (AbstractMinecart)patt9972$temp).m_20184_().m_82556_() > 4.0) {
                    this.findBestSource(global, (Connection)conn).ifPresent(e -> {
                        if (e.getAvailableEnergy() >= 4096) {
                            e.extractEnergy(4096);
                            LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
                            lightningbolt.m_6027_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                            world.m_7967_((Entity)lightningbolt);
                            Vec3 dir = minecart.m_20184_().m_82541_();
                            Vec3 orth = dir.m_82524_((float)Math.toRadians(90.0));
                            Vec3 off = dir.m_82490_(0.125);
                            Vec3 left = minecart.m_20182_().m_82549_(orth.m_82490_(0.625));
                            Vec3 right = minecart.m_20182_().m_82549_(orth.m_82490_(-0.625));
                            for (int i = 0; i < 80; ++i) {
                                left = left.m_82549_(off);
                                right = right.m_82549_(off);
                                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123744_, left.f_82479_, left.f_82480_, left.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
                                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123744_, right.f_82479_, right.f_82480_, right.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
                            }
                            Utils.unlockIEAdvancement(player, "tools/secret_bttf");
                        }
                    });
                }
            });
        }
    }

    private Optional<EnergyTransferHandler.EnergyConnector> findBestSource(GlobalWireNetwork globalNetwork, Connection connection) {
        EnergyTransferHandler energyHandler = connection.getContainingNet(globalNetwork).getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class);
        if (energyHandler == null) {
            return Optional.empty();
        }
        return energyHandler.getSources().values().stream().filter(o -> o.getAvailableEnergy() > 0).max(Comparator.comparingInt(EnergyTransferHandler.EnergyConnector::getAvailableEnergy));
    }

    private void handleMagnetTick(ItemStack itemStack, Level world, Player player) {
        if (world.m_5776_()) {
            return;
        }
        int radius = 6;
        List items = world.m_6443_(ItemEntity.class, player.m_20191_().m_82377_(6.0, 6.0, 6.0), itemEntity -> {
            if (itemEntity.m_32063_()) {
                return false;
            }
            String magnetSource = itemEntity.getPersistentData().m_128461_("immersiveengineering:magnet_source");
            if (!magnetSource.isEmpty() && !magnetSource.equals(player.m_20149_())) {
                return false;
            }
            return !itemEntity.getPersistentData().m_128441_("PreventRemoteMovement");
        });
        for (ItemEntity itemEntity2 : items) {
            if (!((double)itemEntity2.m_20270_((Entity)player) > 0.001) || EnergyHelper.extractFlux((ICapabilityProvider)itemStack, 8, false) < 8) continue;
            if (!itemEntity2.getPersistentData().m_128441_("immersiveengineering:magnet_source")) {
                itemEntity2.m_5496_((SoundEvent)IESounds.electromagnet.get(), (float)(0.125 + player.m_217043_().m_188500_() * 0.25), 1.0f);
                itemEntity2.getPersistentData().m_128359_("immersiveengineering:magnet_source", player.m_20149_());
            }
            Vec3 dist = player.m_20182_().m_82546_(itemEntity2.m_20182_());
            Vec3 diffToPlayer = new Vec3(Math.min(dist.f_82479_, 1.0), Math.min(dist.f_82480_, 1.0), Math.min(dist.f_82481_, 1.0)).m_82546_(player.m_20184_());
            itemEntity2.m_20256_(diffToPlayer.m_82490_(0.2));
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemNBTHelper.hasKey(stack, "energy")) {
            int previousEnergy = ItemNBTHelper.getInt(stack, "energy");
            IItemHandler inv = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(RuntimeException::new);
            ItemStack newCapacitor = new ItemStack(IEBlocks.MetalDevices.CAPACITOR_LV);
            ItemNBTHelper.putInt(newCapacitor, "energy", previousEnergy);
            ((IItemHandlerModifiable)inv).setStackInSlot(0, newCapacitor);
            ItemNBTHelper.remove(stack, "energy");
        }
        if (itemSlot == -1 && entity instanceof Player) {
            this.onArmorTick(stack, world, (Player)entity);
        }
    }

    public static ItemStack getCapacitorStatic(ItemStack container) {
        if (ForgeCapabilities.ITEM_HANDLER == null) {
            return ItemStack.f_41583_;
        }
        LazyOptional cap = container.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (cap.isPresent()) {
            ItemStack capacitor = cap.map(handler -> handler.getStackInSlot(0)).orElse(ItemStack.f_41583_);
            return capacitorConfigMap.get().containsKey(capacitor.m_41720_()) ? capacitor : ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getBannerStatic(ItemStack container) {
        if (ForgeCapabilities.ITEM_HANDLER == null) {
            return ItemStack.f_41583_;
        }
        LazyOptional cap = container.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (cap.isPresent()) {
            ItemStack banner = cap.map(handler -> handler.getStackInSlot(1)).orElse(ItemStack.f_41583_);
            if (banner.m_41720_() instanceof BannerItem) {
                return banner;
            }
            if (banner.m_41720_() instanceof IShaderItem) {
                return banner;
            }
        }
        return ItemStack.f_41583_;
    }

    public static int getMaxEnergyStored(ItemStack container) {
        IEServerConfig.Machines.CapacitorConfig cfg;
        ItemStack capacitor = PowerpackItem.getCapacitorStatic(container);
        if (!capacitor.m_41619_() && (cfg = capacitorConfigMap.get().get(capacitor.m_41720_())) != null) {
            return cfg.storage.getAsInt();
        }
        return 0;
    }

    @Override
    public int getSlotCount() {
        return 4;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new IEItemStackHandler(stack){

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == ForgeCapabilities.ENERGY) {
                        return PowerpackItem.getCapacitorStatic(stack).getCapability(capability, facing);
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return super.initCapabilities(stack, nbt);
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.WithPredicate(toolInventory, 0, 98, 22, itemStack -> capacitorConfigMap.get().containsKey(itemStack.m_41720_())), new IESlot.WithPredicate(toolInventory, 1, 134, 22, itemStack -> itemStack.m_41720_() instanceof BannerItem || itemStack.m_41720_() instanceof IShaderItem), new IESlot.Upgrades(container, toolInventory, 2, 79, 52, "POWERPACK", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 3, 117, 52, "POWERPACK", stack, true, level, getPlayer)};
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        LazyOptional invCap = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        invCap.ifPresent(inv -> {
            if (!(inv.getStackInSlot(0).m_41619_() || inv.getStackInSlot(2).m_41619_() || inv.getStackInSlot(3).m_41619_())) {
                Utils.unlockIEAdvancement(player, "tools/upgrade_powerpack");
            }
        });
    }
}

