/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.item;

import com.google.common.base.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class Stack {
    private Item item;
    private int meta;
    private Type type;

    public Stack(ItemStack stack) {
        if (stack.getItem() instanceof ItemBlock) {
            this.item = stack.getItem();
            this.type = Type.BLOCK;
        } else {
            this.item = stack.getItem();
            this.type = Type.ITEM;
        }
        this.meta = stack.getMetadata();
    }

    public Stack(Item item, int meta) {
        this.item = item;
        this.meta = meta;
        this.type = Type.ITEM;
    }

    public Stack(Block block, int meta) {
        this.item = Item.getItemFromBlock((Block)block);
        this.meta = meta;
        this.type = Type.BLOCK;
    }

    public Item getItem() {
        return this.item;
    }

    public int getMeta() {
        return this.meta;
    }

    public Type getType() {
        return this.type;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.getItem(), 1, this.getMeta());
    }

    public boolean equals(Object o) {
        boolean wild;
        if (!(o instanceof Stack)) {
            return false;
        }
        Stack stack = (Stack)o;
        boolean bl = wild = this.meta == Short.MAX_VALUE || stack.meta == Short.MAX_VALUE;
        return wild ? stack.item.equals(this.item) : stack.item.equals(this.item) && this.meta == stack.meta;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.item});
    }

    public String toString() {
        return String.format("%s->%s:%s:%s", new Object[]{this.getType(), this.getItem().getUnlocalizedName(new ItemStack(this.item, 0, this.meta)), this.getMeta(), this.hashCode()});
    }

    private static enum Type {
        BLOCK,
        ITEM;

    }
}

