/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.fluid;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidBlockWrapper
implements IFluidHandler {
    protected final IFluidBlock fluidBlock;
    protected final World world;
    protected final BlockPos blockPos;

    public FluidBlockWrapper(IFluidBlock fluidBlock, World world, BlockPos blockPos) {
        this.fluidBlock = fluidBlock;
        this.world = world;
        this.blockPos = blockPos;
    }

    public IFluidTankProperties[] getTankProperties() {
        int amountFilled;
        float percentFilled = this.fluidBlock.getFilledPercentage(this.world, this.blockPos);
        if (percentFilled < 0.0f) {
            percentFilled *= -1.0f;
        }
        FluidStack fluid = (amountFilled = Math.round(1000.0f * percentFilled)) > 0 ? new FluidStack(this.fluidBlock.getFluid(), amountFilled) : null;
        return new FluidTankProperties[]{new FluidTankProperties(fluid, 1000, false, true)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        return this.setLiquid(this.world, this.blockPos, this.fluidBlock, 2);
    }

    public int setLiquid(World world, BlockPos pos, IFluidBlock fluidBlock, int level) {
        if (fluidBlock instanceof BlockFluidBase) {
            BlockFluidBase blockFluidBase = (BlockFluidBase)fluidBlock;
            IBlockState state = world.getBlockState(pos);
            Block existingBlock = state.getBlock();
            FluidUtil.destroyBlockOnFluidPlacement((World)world, (BlockPos)pos);
            if (!(existingBlock instanceof BlockFluidBase) && existingBlock.isReplaceable((IBlockAccess)world, pos) || (Integer)state.getValue((IProperty)BlockFluidBase.LEVEL) > level) {
                world.setBlockState(pos, blockFluidBase.getDefaultState().withProperty((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(level)), 11);
            }
            return 1000;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !this.fluidBlock.canDrain(this.world, this.blockPos)) {
            return null;
        }
        FluidStack simulatedDrain = this.fluidBlock.drain(this.world, this.blockPos, false);
        if (resource.containsFluid(simulatedDrain)) {
            return simulatedDrain;
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        return new FluidStack(this.fluidBlock.getFluid(), 1000);
    }
}

