/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.fluid;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BlockLiquidWrapper
implements IFluidHandler {
    protected final BlockLiquid blockLiquid;
    protected final World world;
    protected final BlockPos blockPos;

    public BlockLiquidWrapper(BlockLiquid blockLiquid, World world, BlockPos blockPos) {
        this.blockLiquid = blockLiquid;
        this.world = world;
        this.blockPos = blockPos;
    }

    public IFluidTankProperties[] getTankProperties() {
        FluidStack containedStack = null;
        IBlockState blockState = this.world.getBlockState(this.blockPos);
        if (blockState.getBlock() == this.blockLiquid) {
            containedStack = this.getStack(blockState);
        }
        return new FluidTankProperties[]{new FluidTankProperties(containedStack, 1000, false, true)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.amount < 1000) {
            return 0;
        }
        if (doFill) {
            Material material = this.blockLiquid.getDefaultState().getMaterial();
            BlockDynamicLiquid block = BlockLiquid.getFlowingBlock((Material)material);
            if (!this.world.isRemote) {
                this.setLiquid(this.world, this.blockPos, (Block)block, 2);
                for (EnumFacing facing : EnumFacing.HORIZONTALS) {
                    BlockPos p2 = this.blockPos.offset(facing);
                    this.setLiquid(this.world, p2, (Block)block, 5);
                }
            }
        }
        return 1000;
    }

    public void setLiquid(World world, BlockPos pos, Block block, int level) {
        IBlockState state = world.getBlockState(pos);
        Block existingBlock = state.getBlock();
        if (existingBlock instanceof BlockLiquid && (Integer)state.getValue((IProperty)BlockLiquid.LEVEL) > level || !state.getMaterial().isLiquid() && existingBlock.isReplaceable((IBlockAccess)world, pos)) {
            world.setBlockState(pos, block.getDefaultState().withProperty((IProperty)BlockLiquid.LEVEL, (Comparable)Integer.valueOf(level)), 11);
        }
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack containedStack;
        if (resource == null || resource.amount < 1000) {
            return null;
        }
        IBlockState blockState = this.world.getBlockState(this.blockPos);
        if (blockState.getBlock() == this.blockLiquid && (containedStack = this.getStack(blockState)) != null && resource.containsFluid(containedStack)) {
            return containedStack;
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack containedStack;
        IBlockState blockState = this.world.getBlockState(this.blockPos);
        if (blockState.getBlock() == this.blockLiquid && (containedStack = this.getStack(blockState)) != null) {
            if (containedStack.getFluid() == FluidRegistry.LAVA && containedStack.amount <= maxDrain) {
                if (doDrain) {
                    this.world.setBlockState(this.blockPos, Blocks.AIR.getDefaultState(), 11);
                }
                return null;
            }
            containedStack.amount = maxDrain;
            return containedStack;
        }
        return null;
    }

    @Nullable
    private FluidStack getStack(IBlockState blockState) {
        Material material = blockState.getMaterial();
        if (material == Material.WATER) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (material == Material.LAVA && (Integer)blockState.getValue((IProperty)BlockLiquid.LEVEL) == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }
}

