/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import java.util.Random;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class VectorBuilder {
    private Random random = new Random();
    private double x;
    private double y;
    private double z;

    public VectorBuilder set(Vec3i pos) {
        return this.set(pos.getX(), pos.getY(), pos.getZ());
    }

    public VectorBuilder set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public VectorBuilder offset(double offset) {
        return this.offset(offset, offset, offset);
    }

    public VectorBuilder offset(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public VectorBuilder rand(double multiplier) {
        return this.rand(multiplier, multiplier, multiplier);
    }

    public VectorBuilder rand(double multiplierX, double multiplierY, double multiplierZ) {
        this.x += this.random.nextDouble() * multiplierX;
        this.y += this.random.nextDouble() * multiplierY;
        this.z += this.random.nextDouble() * multiplierZ;
        return this;
    }

    public VectorBuilder setGaussian(double multiplierX, double multiplierY, double multiplierZ) {
        this.x = this.random.nextGaussian() * multiplierX;
        this.y = this.random.nextGaussian() * multiplierY;
        this.z = this.random.nextGaussian() * multiplierZ;
        return this;
    }

    public VectorBuilder setGaussian(double multiplier) {
        return this.setGaussian(multiplier, multiplier, multiplier);
    }

    public VectorBuilder reset() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public Vec3d build() {
        Vec3d vec = new Vec3d(this.x, this.y, this.z);
        this.reset();
        return vec;
    }
}

