/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.util.Quaternion;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.tuple.Pair;

public final class SpaceUtils {
    public static final byte GET_POINT_MIN = 0;
    public static final byte GET_POINT_MAX = 7;
    private static final int[][] ROTATION_MATRIX = new int[][]{{0, 1, 4, 5, 3, 2}, {0, 1, 5, 4, 2, 3}, {5, 4, 2, 3, 0, 1}, {4, 5, 2, 3, 1, 0}, {2, 3, 1, 0, 4, 5}, {3, 2, 0, 1, 4, 5}, {0, 1, 2, 3, 4, 5}};
    private static final int[][] ROTATION_MATRIX_INV = new int[6][6];

    public static EnumFacing determineOrientation(EntityLivingBase player) {
        if (player.rotationPitch > 75.0f) {
            return EnumFacing.DOWN;
        }
        if (player.rotationPitch <= -75.0f) {
            return EnumFacing.UP;
        }
        return SpaceUtils.determineFlatOrientation(player);
    }

    public static EnumFacing determineFlatOrientation(EntityLivingBase player) {
        int var7 = MathHelper.floor((double)((double)((180.0f + player.rotationYaw) * 4.0f / 360.0f) + 0.5)) & 3;
        int r = var7 == 0 ? 2 : (var7 == 1 ? 5 : (var7 == 2 ? 3 : (var7 == 3 ? 4 : 0)));
        return EnumFacing.VALUES[r];
    }

    public static Vec3d copy(Vec3d a) {
        return new Vec3d(a.x, a.y, a.z);
    }

    public static AxisAlignedBB copy(AxisAlignedBB box) {
        return new AxisAlignedBB(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    public static Vec3d getEntityVelocity(Entity ent) {
        return new Vec3d(ent.motionX, ent.motionY, ent.motionZ);
    }

    public static void setEntityVelocity(Entity ent, Vec3d vec) {
        ent.motionX = vec.x;
        ent.motionY = vec.y;
        ent.motionZ = vec.z;
    }

    public static int ordinal(@Nullable EnumFacing side) {
        return side == null ? 6 : side.ordinal();
    }

    @Nullable
    public static EnumFacing getFacing(int ordinal) {
        return ordinal == 6 ? null : EnumFacing.getFront((int)ordinal);
    }

    public static Vec3d fromPlayerEyePos(EntityPlayer ent) {
        if (ent.world.isRemote) {
            return new Vec3d(ent.posX, ent.posY + (double)(ent.getEyeHeight() - ent.getDefaultEyeHeight()), ent.posZ);
        }
        return new Vec3d(ent.posX, ent.posY + (double)ent.getEyeHeight(), ent.posZ);
    }

    public static void setEntityPosition(Entity ent, Vec3d pos) {
        ent.posX = pos.x;
        ent.posY = pos.y;
        ent.posZ = pos.z;
    }

    public static void setEntPos(Entity ent, Vec3d pos) {
        ent.setPosition(pos.x, pos.y, pos.z);
    }

    public static AxisAlignedBB setMin(AxisAlignedBB aabb, Vec3d v) {
        return new AxisAlignedBB(v.x, v.y, v.z, aabb.maxX, aabb.maxY, aabb.maxZ);
    }

    public static Vec3d getMax(AxisAlignedBB aabb) {
        return new Vec3d(aabb.maxX, aabb.maxY, aabb.maxZ);
    }

    public static Vec3d getMin(AxisAlignedBB aabb) {
        return new Vec3d(aabb.minX, aabb.minY, aabb.minZ);
    }

    public static AxisAlignedBB setMax(AxisAlignedBB aabb, Vec3d v) {
        return new AxisAlignedBB(aabb.minX, aabb.minY, aabb.minZ, v.x, v.y, v.z);
    }

    public static Vec3d getMiddle(AxisAlignedBB ab) {
        return new Vec3d((ab.minX + ab.maxX) / 2.0, (ab.minY + ab.maxY) / 2.0, (ab.minZ + ab.maxZ) / 2.0);
    }

    public static Vec3d fromDirection(EnumFacing dir) {
        return new Vec3d(dir.getDirectionVec());
    }

    public static Pair<Vec3d, Vec3d> sort(Vec3d left, Vec3d right) {
        double minX = Math.min(left.x, right.x);
        double maxX = Math.max(left.x, right.x);
        double minY = Math.min(left.y, right.y);
        double maxY = Math.max(left.y, right.y);
        double minZ = Math.min(left.z, right.z);
        double maxZ = Math.max(left.z, right.z);
        return Pair.of((Object)new Vec3d(minX, minY, minZ), (Object)new Vec3d(maxX, maxY, maxZ));
    }

    public static Vec3d getVertex(AxisAlignedBB box, byte pointFlags) {
        boolean xSide = (pointFlags & 1) == 1;
        boolean ySide = (pointFlags & 2) == 2;
        boolean zSide = (pointFlags & 4) == 4;
        return new Vec3d(xSide ? box.minX : box.maxX, ySide ? box.minY : box.maxY, zSide ? box.minZ : box.maxZ);
    }

    public static AxisAlignedBB flatten(AxisAlignedBB box, EnumFacing face) {
        byte[] lows = new byte[]{2, 0, 4, 0, 1, 0};
        byte[] hghs = new byte[]{7, 5, 7, 3, 7, 6};
        byte low = lows[face.ordinal()];
        byte high = hghs[face.ordinal()];
        assert (low != high);
        assert ((~low & 7) != high);
        return new AxisAlignedBB(SpaceUtils.getVertex(box, low), SpaceUtils.getVertex(box, high));
    }

    public static double getDiagonalLength(AxisAlignedBB ab) {
        double x = ab.maxX - ab.minX;
        double y = ab.maxY - ab.minY;
        double z = ab.maxZ - ab.minZ;
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static Vec3d average(Vec3d a, Vec3d b) {
        return new Vec3d((a.x + b.x) / 2.0, (a.y + b.y) / 2.0, (a.z + b.z) / 2.0);
    }

    public static double getAngle(Vec3d a, Vec3d b) {
        double mags;
        double dot = a.dotProduct(b);
        double div = dot / (mags = a.lengthVector() * b.lengthVector());
        if (div > 1.0) {
            div = 1.0;
        }
        if (div < -1.0) {
            div = -1.0;
        }
        return Math.acos(div);
    }

    public static AxisAlignedBB withPoints(Vec3d[] parts) {
        return new AxisAlignedBB(SpaceUtils.getLowest(parts), SpaceUtils.getHighest(parts));
    }

    public static Vec3d scale(Vec3d base, double s) {
        return new Vec3d(base.x * s, base.y * s, base.z * s);
    }

    public static Vec3d componentMultiply(Vec3d a, Vec3d b) {
        return new Vec3d(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Vec3d componentMultiply(Vec3d a, double x, double y, double z) {
        return new Vec3d(a.x + x, a.y + y, a.z + z);
    }

    public static AxisAlignedBB sortedBox(Vec3d min, Vec3d max) {
        double minX = Math.min(min.x, max.x);
        double minY = Math.min(min.y, max.y);
        double minZ = Math.min(min.z, max.z);
        double maxX = Math.max(min.x, max.x);
        double maxY = Math.max(min.y, max.y);
        double maxZ = Math.max(min.z, max.z);
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static AxisAlignedBB withPoint(AxisAlignedBB box, Vec3d vec) {
        return new AxisAlignedBB(vec.x < box.minX ? vec.x : box.minX, vec.y < box.minY ? vec.y : box.minY, vec.z < box.minZ ? vec.z : box.minZ, box.maxX < vec.x ? vec.x : box.maxX, box.maxY < vec.y ? vec.y : box.maxY, box.maxZ < vec.z ? vec.z : box.maxZ);
    }

    public static Vec3d[] getCorners(AxisAlignedBB box) {
        return new Vec3d[]{new Vec3d(box.minX, box.minY, box.minZ), new Vec3d(box.minX, box.maxY, box.minZ), new Vec3d(box.maxX, box.maxY, box.minZ), new Vec3d(box.maxX, box.minY, box.minZ), new Vec3d(box.minX, box.minY, box.maxZ), new Vec3d(box.minX, box.maxY, box.maxZ), new Vec3d(box.maxX, box.maxY, box.maxZ), new Vec3d(box.maxX, box.minY, box.maxZ)};
    }

    public static Vec3d getLowest(Vec3d[] vs) {
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        boolean first = true;
        for (int i = 0; i < vs.length; ++i) {
            Vec3d v = vs[i];
            if (v == null) continue;
            if (first) {
                first = false;
                x = v.x;
                y = v.y;
                z = v.z;
                continue;
            }
            if (v.x < x) {
                x = v.x;
            }
            if (v.y < y) {
                y = v.y;
            }
            if (!(v.z < z)) continue;
            z = v.z;
        }
        return new Vec3d(x, y, z);
    }

    public static Vec3d getHighest(Vec3d[] vs) {
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        boolean first = true;
        for (int i = 0; i < vs.length; ++i) {
            Vec3d v = vs[i];
            if (v == null) continue;
            if (first) {
                first = false;
                x = v.x;
                y = v.y;
                z = v.z;
                continue;
            }
            if (v.x > x) {
                x = v.x;
            }
            if (v.y > y) {
                y = v.y;
            }
            if (!(v.z > z)) continue;
            z = v.z;
        }
        return new Vec3d(x, y, z);
    }

    public static boolean isZero(Vec3d vec) {
        return vec.x == 0.0 && vec.y == 0.0 && vec.z == 0.0;
    }

    public static double lineDistance(Vec3d lineVec, Vec3d point) {
        double mag = lineVec.lengthVector();
        Vec3d nPoint = SpaceUtils.scale(point, -1.0);
        return lineVec.crossProduct(nPoint).lengthVector() / mag;
    }

    public static double lineDistance(Vec3d origin, Vec3d lineVec, Vec3d point) {
        return SpaceUtils.lineDistance(lineVec.subtract(origin), point.subtract(origin));
    }

    public static EnumFacing getOrientation(int ordinal) {
        if (ordinal < 0) {
            return null;
        }
        if (ordinal >= 6) {
            return null;
        }
        return EnumFacing.VALUES[ordinal];
    }

    public static int sign(EnumFacing dir) {
        return dir != null ? dir.getAxisDirection().getOffset() : 0;
    }

    public static double componentSum(Vec3d vec) {
        return vec.x + vec.y + vec.z;
    }

    public static EnumFacing getClosestDirection(Vec3d vec) {
        return SpaceUtils.getClosestDirection(vec, null);
    }

    public static EnumFacing getClosestDirection(Vec3d vec, EnumFacing not) {
        if (SpaceUtils.isZero(vec)) {
            return null;
        }
        double bestAngle = Double.POSITIVE_INFINITY;
        EnumFacing closest = null;
        for (EnumFacing dir : EnumFacing.VALUES) {
            Vec3i work;
            double dot;
            if (dir == not || !((dot = SpaceUtils.getAngle(vec, new Vec3d(work = dir.getDirectionVec()))) < bestAngle)) continue;
            bestAngle = dot;
            closest = dir;
        }
        return closest;
    }

    public static Vec3d floor(Vec3d vec) {
        return new Vec3d(Math.floor(vec.x), Math.floor(vec.y), Math.floor(vec.z));
    }

    public static Vec3d normalize(Vec3d v) {
        double length = v.lengthVector();
        if (length == 0.0) {
            return Vec3d.ZERO;
        }
        double inv = 1.0 / length;
        if (Double.isNaN(inv) || Double.isInfinite(inv)) {
            return Vec3d.ZERO;
        }
        return SpaceUtils.scale(v, inv);
    }

    public static AxisAlignedBB include(AxisAlignedBB box, BlockPos at) {
        double minX = box.minX;
        double maxX = box.maxX;
        double minY = box.minY;
        double maxY = box.maxY;
        double minZ = box.minZ;
        double maxZ = box.maxZ;
        if ((double)at.getX() < minX) {
            minX = at.getX();
        }
        if ((double)(at.getX() + 1) > maxX) {
            maxX = at.getX() + 1;
        }
        if ((double)at.getY() < minY) {
            minY = at.getY();
        }
        if ((double)(at.getY() + 1) > maxY) {
            maxY = at.getY() + 1;
        }
        if ((double)at.getZ() < minZ) {
            minZ = at.getZ();
        }
        if ((double)(at.getZ() + 1) > maxZ) {
            maxZ = at.getZ() + 1;
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static AxisAlignedBB include(AxisAlignedBB box, Vec3d at) {
        double minX = box.minX;
        double maxX = box.maxX;
        double minY = box.minY;
        double maxY = box.maxY;
        double minZ = box.minZ;
        double maxZ = box.maxZ;
        if (at.x < minX) {
            minX = at.x;
        }
        if (at.x > maxX) {
            maxX = at.x;
        }
        if (at.y < minY) {
            minY = at.y;
        }
        if (at.y > maxY) {
            maxY = at.y;
        }
        if (at.z < minZ) {
            minZ = at.z;
        }
        if (at.z > maxZ) {
            maxZ = at.z;
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static double getVolume(AxisAlignedBB box) {
        if (box == null) {
            return 0.0;
        }
        double x = box.maxX - box.minX;
        double y = box.maxY - box.minY;
        double z = box.maxZ - box.minZ;
        double volume = x * y * z;
        if (volume < 0.0) {
            return 0.0;
        }
        return volume;
    }

    public static AxisAlignedBB createBox(BlockPos at, int radius) {
        return new AxisAlignedBB(at.add(-radius, -radius, -radius), at.add(radius + 1, radius + 1, radius + 1));
    }

    public static EnumFacing rotateDirection(EnumFacing dir, Quaternion rot, Iterable<EnumFacing> allow) {
        Vec3d v = SpaceUtils.fromDirection(dir);
        rot.applyRotation(v);
        EnumFacing best = null;
        double bestDot = Double.POSITIVE_INFINITY;
        for (EnumFacing fd : allow) {
            Vec3d f = SpaceUtils.fromDirection(fd);
            rot.applyRotation(f);
            double dot = v.dotProduct(f);
            if (!(dot < bestDot)) continue;
            bestDot = dot;
            best = fd;
        }
        return best;
    }

    public static EnumFacing rotateDirectionAndExclude(EnumFacing dir, Quaternion rot, Collection<EnumFacing> allow) {
        EnumFacing ret = SpaceUtils.rotateDirection(dir, rot, allow);
        allow.remove(ret);
        allow.remove(ret.getOpposite());
        return ret;
    }

    public static EnumFacing rotateCounterclockwise(EnumFacing dir, EnumFacing axis) {
        return EnumFacing.VALUES[ROTATION_MATRIX[axis.ordinal()][dir.ordinal()]];
    }

    public static EnumFacing rotateClockwise(EnumFacing dir, EnumFacing axis) {
        return EnumFacing.VALUES[ROTATION_MATRIX_INV[axis.ordinal()][dir.ordinal()]];
    }

    public static Iterable<BlockPos.MutableBlockPos> iterateAround(BlockPos src, int radius) {
        return BlockPos.getAllInBoxMutable((BlockPos)src.add(-radius, -radius, -radius), (BlockPos)src.add(radius, radius, radius));
    }

    public static Vector3d toJavaVector(Vec3d val) {
        return new Vector3d(val.x, val.y, val.z);
    }

    public static AxisAlignedBB getChunkBoundingBox(Chunk chunk) {
        int minX = chunk.x << 4;
        int minZ = chunk.z << 4;
        return new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)(minX + 16), 255.0, (double)(minZ + 16));
    }

    static {
        for (int axis = 0; axis < 6; ++axis) {
            for (int dir = 0; dir < 6; ++dir) {
                int out = dir;
                out = ROTATION_MATRIX[axis][out];
                out = ROTATION_MATRIX[axis][out];
                SpaceUtils.ROTATION_MATRIX_INV[axis][dir] = out = ROTATION_MATRIX[axis][out];
            }
        }
    }
}

