/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class DispenserBehaviorFiniteWater
extends BehaviorDefaultDispenseItem {
    private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

    public ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
        if (FluidUtil.getFluidContained((ItemStack)stack) != null) {
            return this.dumpContainer(source, stack);
        }
        return this.fillContainer(source, stack);
    }

    private ItemStack fillContainer(IBlockSource source, ItemStack stack) {
        World world = source.getWorld();
        EnumFacing dispenserFacing = (EnumFacing)source.getBlockState().getValue((IProperty)BlockDispenser.FACING);
        BlockPos blockpos = source.getBlockPos().offset(dispenserFacing);
        ItemStack result = FluidUtil.tryPickUpFluid((ItemStack)stack, null, (World)world, (BlockPos)blockpos, (EnumFacing)dispenserFacing.getOpposite()).getResult();
        if (result.isEmpty()) {
            return super.dispenseStack(source, stack);
        }
        if (stack.getCount() == 0) {
            stack.deserializeNBT(result.serializeNBT());
        } else if (((TileEntityDispenser)source.getBlockTileEntity()).addItemStack(result) < 0) {
            this.dispenseBehavior.dispense(source, result);
        }
        stack.shrink(1);
        return stack;
    }

    private ItemStack dumpContainer(IBlockSource source, ItemStack stack) {
        ItemStack dispensedStack = stack.copy();
        dispensedStack.setCount(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)dispensedStack);
        if (fluidHandler == null) {
            return super.dispenseStack(source, stack);
        }
        FluidStack fluidStack = fluidHandler.drain(1000, false);
        EnumFacing dispenserFacing = (EnumFacing)source.getBlockState().getValue((IProperty)BlockDispenser.FACING);
        BlockPos blockpos = source.getBlockPos().offset(dispenserFacing);
        if (fluidStack != null && fluidStack.amount == 1000 && FluidUtil.tryPlaceFluid(null, (World)source.getWorld(), (BlockPos)blockpos, (ItemStack)stack.getItem().getContainerItem(stack), (FluidStack)fluidStack) != FluidActionResult.FAILURE) {
            if (fluidStack.getFluid() == FluidRegistry.WATER) {
                source.getWorld().setBlockState(blockpos, Blocks.FLOWING_WATER.getStateFromMeta(2));
                for (EnumFacing face : EnumFacing.HORIZONTALS) {
                    BlockPos off = blockpos.offset(face);
                    if (!source.getWorld().isAirBlock(off) && !source.getWorld().getBlockState(off).getBlock().isReplaceable((IBlockAccess)source.getWorld(), off)) continue;
                    source.getWorld().setBlockState(off, Blocks.FLOWING_WATER.getStateFromMeta(5));
                }
            }
            fluidHandler.drain(1000, true);
            stack.shrink(1);
            if (stack.getCount() == 0) {
                stack.deserializeNBT(dispensedStack.serializeNBT());
            } else if (((TileEntityDispenser)source.getBlockTileEntity()).addItemStack(dispensedStack) < 0) {
                this.dispenseBehavior.dispense(source, dispensedStack);
            }
            return stack;
        }
        return this.dispenseBehavior.dispense(source, stack);
    }
}

