/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class DirUtils {
    public static final EnumFacing[] X_AXIS = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST};
    public static final EnumFacing[] Y_AXIS = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
    public static final EnumFacing[] Z_AXIS = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH};
    public static final EnumFacing[] NOT_DOWN = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.UP};
    public static final EnumFacing[][] AXIS_DIRECTIONS = new EnumFacing[][]{X_AXIS, Y_AXIS, Z_AXIS};
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.create((String)"axis", EnumFacing.Axis.class);
    public static final PropertyDirection FACING = BlockDirectional.FACING;
    public static final PropertyDirection HORIZONTAL = PropertyDirection.create((String)"facing", (Collection)Lists.newArrayList((Object[])EnumFacing.Plane.HORIZONTAL.facings()));
    public static final PropertyDirection TILTING = PropertyDirection.create((String)"facing", facing -> facing != EnumFacing.DOWN);
    public static final PropertyBool UP = PropertyBool.create((String)"up");
    public static final PropertyBool DOWN = PropertyBool.create((String)"down");
    public static final PropertyBool NORTH = PropertyBool.create((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.create((String)"south");
    public static final PropertyBool WEST = PropertyBool.create((String)"west");
    public static final PropertyBool EAST = PropertyBool.create((String)"east");
    public static final PropertyBool[] DIR_PROP_HORIZ = new PropertyBool[]{NORTH, SOUTH, WEST, EAST};
    public static final PropertyBool[] DIR_PROP = new PropertyBool[]{DOWN, UP, NORTH, SOUTH, EAST, WEST};

    public static EnumFacing getRandomFacing(List<EnumFacing> validDirections, Random random) {
        return validDirections.get(random.nextInt(validDirections.size()));
    }

    public static void setEntityOrientationFacing(EntityLivingBase entity, EnumFacing side) {
        float pitch = 0.0f;
        float yaw = 0.0f;
        switch (side) {
            case UP: {
                pitch = 61.0f;
                break;
            }
            case DOWN: {
                pitch = -61.0f;
                break;
            }
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
                break;
            }
            case EAST: {
                yaw = -90.0f;
            }
        }
        entity.rotationYaw = yaw;
        entity.rotationPitch = pitch;
    }

    public static EnumFacing convertEntityOrientationToFacing(EntityLivingBase entity, EnumFacing side) {
        if (entity == null) {
            return side;
        }
        float pitch = entity.rotationPitch;
        if (pitch > 60.0f) {
            return EnumFacing.UP;
        }
        if (pitch < -60.0f) {
            return EnumFacing.DOWN;
        }
        return DirUtils.convertEntityOrientationToFlatFacing(entity, side);
    }

    public static EnumFacing convertEntityOrientationToFlatFacing(EntityLivingBase entity, EnumFacing side) {
        if (entity == null) {
            return side;
        }
        return entity.getHorizontalFacing().getOpposite();
    }

    public static EnumFacing convertEntityOrientationToFlatFacing(EntityLivingBase entity) {
        return entity.getHorizontalFacing().getOpposite();
    }

    public static EnumFacing getOpposite(EnumFacing facing) {
        return facing.getOpposite();
    }

    public static EnumFacing rotateFacingAroundY(EnumFacing facing, boolean reverse) {
        if (facing.ordinal() >= 2) {
            switch (facing) {
                case NORTH: {
                    facing = EnumFacing.EAST;
                    break;
                }
                case SOUTH: {
                    facing = EnumFacing.WEST;
                    break;
                }
                case WEST: {
                    facing = EnumFacing.NORTH;
                    break;
                }
                case EAST: {
                    facing = EnumFacing.SOUTH;
                    break;
                }
            }
            if (reverse) {
                facing = DirUtils.getOpposite(facing);
            }
        }
        return facing;
    }

    public static EnumFacing.Axis getAxis(int axis) {
        return EnumFacing.Axis.values()[axis];
    }

    public static BlockPos movePos(BlockPos source, EnumFacing facing) {
        return source.add(facing.getDirectionVec());
    }

    public static EnumFacing[] getAxisDirection(EnumFacing.Axis axis) {
        return AXIS_DIRECTIONS[axis.ordinal()];
    }
}

