/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.common.entity.ai.EntityAIFlee;
import betterwithmods.module.Feature;
import betterwithmods.util.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ImprovedFlee
extends Feature {
    private static boolean blockPlace;
    private static boolean blockBreak;
    private static boolean groupFlee;

    public static boolean canSeeBlock(BlockPos pos, EntityLiving entity) {
        RayTraceResult result = entity.world.rayTraceBlocks(entity.getPositionVector(), new Vec3d((Vec3i)pos).addVector(0.5, 0.5, 0.5));
        return result != null && pos.equals((Object)result.getBlockPos());
    }

    @Override
    public void setupConfig() {
        blockPlace = this.loadPropBool("Animals Flee from Block Place", "When a block is placed in the vicinity of an animal it will get scared and run.", true);
        blockBreak = this.loadPropBool("Animals Flee from Block Break", "When a non-replaceable block is broken in the vicinity of an animal it will get scared and run.", true);
        groupFlee = this.loadPropBool("Animals Group Flee", "When an animal is attacked in the vicinity of another animal it will get scared and run.", true);
    }

    @SubscribeEvent
    public void addEntityAI(EntityJoinWorldEvent evt) {
        EntityLiving entity;
        if (evt.getEntity() instanceof EntityLiving && (entity = (EntityLiving)evt.getEntity()) instanceof EntityAnimal && EntityUtils.hasAI(entity, EntityAIPanic.class)) {
            float speed = (float)entity.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getAttributeValue() * 7.0f;
            EntityUtils.removeAI(entity, EntityAIPanic.class);
            entity.tasks.addTask(0, (EntityAIBase)new EntityAIFlee((EntityCreature)entity, speed));
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.PlaceEvent event) {
        if (!blockPlace) {
            return;
        }
        if (event.getPlayer() != null) {
            AxisAlignedBB box = event.getPlacedBlock().getBoundingBox((IBlockAccess)event.getWorld(), event.getPos()).offset(event.getPos()).grow(10.0);
            for (EntityAnimal animal : event.getWorld().getEntitiesWithinAABB(EntityAnimal.class, box)) {
                if (this.cantBeScared(animal) || !ImprovedFlee.canSeeBlock(event.getPos(), (EntityLiving)animal)) continue;
                animal.setRevengeTarget((EntityLivingBase)event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (!blockBreak) {
            return;
        }
        if (event.getPlayer() != null && !event.getState().getMaterial().isReplaceable()) {
            AxisAlignedBB box = event.getState().getBoundingBox((IBlockAccess)event.getWorld(), event.getPos()).offset(event.getPos()).grow(10.0);
            for (EntityAnimal animal : event.getWorld().getEntitiesWithinAABB(EntityAnimal.class, box)) {
                if (this.cantBeScared(animal) || !ImprovedFlee.canSeeBlock(event.getPos(), (EntityLiving)animal)) continue;
                animal.setRevengeTarget((EntityLivingBase)event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onGroupFlee(LivingSetAttackTargetEvent event) {
        if (!groupFlee) {
            return;
        }
        if (event.getTarget() != null && event.getEntityLiving() instanceof EntityAnimal) {
            EntityAnimal a = (EntityAnimal)event.getEntityLiving();
            AxisAlignedBB box = new AxisAlignedBB(a.posX, a.posY, a.posZ, a.posX + 1.0, a.posY + 1.0, a.posZ + 1.0).grow(10.0);
            for (EntityAnimal animal : a.getEntityWorld().getEntitiesWithinAABB(EntityAnimal.class, box, entity -> entity != null && entity != a && entity.getRevengeTarget() == null)) {
                if (this.cantBeScared(animal) || !animal.canEntityBeSeen((Entity)a)) continue;
                animal.setRevengeTarget(event.getTarget());
            }
        }
    }

    private boolean cantBeScared(EntityAnimal animal) {
        if (animal instanceof EntityTameable && ((EntityTameable)animal).isTamed()) {
            return true;
        }
        if (animal instanceof AbstractHorse && ((AbstractHorse)animal).isTame()) {
            return true;
        }
        return !EntityUtils.hasAI((EntityLiving)animal, EntityAIFlee.class);
    }

    @Override
    public String getFeatureDescription() {
        return "Improve fleeing AI for attacked animals";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

