/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.common.items.ItemArcaneScroll;
import betterwithmods.module.Feature;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class EnchantmentTooltip
extends Feature {
    @SideOnly(value=Side.CLIENT)
    public static String getTranslatedEnchantment(@Nullable Enchantment enchantment) {
        if (enchantment != null && enchantment.type != null) {
            String name = enchantment.type.name().toLowerCase();
            String key = String.format("bwm.enchantment.type.%s", name);
            if (I18n.hasKey((String)key)) {
                return I18n.format((String)key, (Object[])new Object[0]);
            }
            return StringUtils.capitalize((String)name.replace("_", " "));
        }
        return null;
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        Enchantment enchantment;
        String tooltip;
        ItemStack stack = event.getItemStack();
        if (stack.getItem() instanceof ItemEnchantedBook) {
            NBTTagList nbttaglist = ItemEnchantedBook.getEnchantments((ItemStack)stack);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
                short j = nbttagcompound.getShort("id");
                Enchantment enchantment2 = Enchantment.getEnchantmentByID((int)j);
                String tooltip2 = EnchantmentTooltip.getTranslatedEnchantment(enchantment2);
                if (tooltip2 == null) continue;
                event.getToolTip().add(tooltip2);
            }
        } else if (stack.getItem() instanceof ItemArcaneScroll && (tooltip = EnchantmentTooltip.getTranslatedEnchantment(enchantment = ItemArcaneScroll.getEnchantment(stack))) != null) {
            event.getToolTip().add(tooltip);
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Add a tooltip to Enchantment source items (Scrolls, Books) to show what type of tool the enchantment can be used on.";
    }
}

