/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.common.BWMItems;
import betterwithmods.common.entity.EntityShearedCreeper;
import betterwithmods.module.Feature;
import betterwithmods.util.EntityUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CreeperShearing
extends Feature {
    public static ResourceLocation CREEPER = new ResourceLocation("minecraft", "creeper");

    @SubscribeEvent
    public void mobDrops(LivingDropsEvent event) {
        double chance;
        EntityLivingBase entity = event.getEntityLiving();
        if (EntityList.isMatchingName((Entity)entity, (ResourceLocation)CREEPER) && (chance = entity.getRNG().nextDouble() + 0.1 * (double)event.getLootingLevel()) <= 0.05) {
            WorldUtils.addDrop(event, new ItemStack(BWMItems.CREEPER_OYSTER));
        }
    }

    @SubscribeEvent
    public void shearCreeper(PlayerInteractEvent.EntityInteractSpecific e) {
        Item item;
        EntityLivingBase creeper;
        if (e.getTarget() instanceof EntityLivingBase && EntityList.isMatchingName((Entity)(creeper = (EntityLivingBase)e.getTarget()), (ResourceLocation)CREEPER) && e.getSide().isServer() && creeper.isEntityAlive() && !e.getItemStack().isEmpty() && (item = e.getItemStack().getItem()) instanceof ItemShears) {
            if (e.getEntityPlayer().getCooldownTracker().hasCooldown(item)) {
                return;
            }
            e.getEntityPlayer().getCooldownTracker().setCooldown(item, 20);
            e.getItemStack().damageItem(1, e.getEntityLiving());
            InvUtils.ejectStack(e.getWorld(), creeper.posX, creeper.posY, creeper.posZ, new ItemStack(BWMItems.CREEPER_OYSTER));
            EntityShearedCreeper shearedCreeper = new EntityShearedCreeper(e.getWorld());
            creeper.attackEntityFrom(new DamageSource(""), 0.0f);
            EntityUtils.copyEntityInfo(creeper, (EntityLivingBase)shearedCreeper);
            e.getWorld().playSound(null, shearedCreeper.posX, shearedCreeper.posY, shearedCreeper.posZ, SoundEvents.ENTITY_SLIME_JUMP, SoundCategory.HOSTILE, 1.0f, 0.3f);
            e.getWorld().playSound(null, shearedCreeper.posX, shearedCreeper.posY, shearedCreeper.posZ, SoundEvents.ENTITY_SHEEP_SHEAR, SoundCategory.HOSTILE, 1.0f, 1.0f);
            creeper.setDead();
            e.getWorld().spawnEntity((Entity)shearedCreeper);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureDescription() {
        return "Shearing a Creeper will removes its ability to explode, making him very sad";
    }
}

