/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.industry.pollution;

import betterwithmods.api.capabilities.PollutionCapability;
import betterwithmods.api.tile.IPollutant;
import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.common.items.tools.ItemSoulforgeArmor;
import betterwithmods.module.industry.pollution.CapabilityFurnacePollution;
import betterwithmods.module.industry.pollution.IWorldPollution;
import betterwithmods.module.industry.pollution.WorldPollutionCapability;
import betterwithmods.util.player.PlayerHelper;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PollutionHandler {
    public HashMap<String, Float> biomeMods = new HashMap();

    @SubscribeEvent
    public void onMobSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (!(event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        EntityLiving living = (EntityLiving)event.getEntityLiving();
        BlockPos pos = new BlockPos((double)event.getX(), 0.0, (double)event.getZ());
        float pollution = this.getPollutionStat(event.getWorld(), new ChunkPos(pos));
        if (pollution > 0.0f) {
            event.setCanceled(true);
            living.onInitialSpawn(PollutionHandler.getDifficultyForLocation(event.getWorld(), pos, pollution), null);
        } else {
            living.onInitialSpawn(event.getWorld().getDifficultyForLocation(pos), null);
        }
    }

    public static DifficultyInstance getDifficultyForLocation(World world, BlockPos pos, float pollution) {
        long i = 0L;
        float f = 0.0f;
        if (world.isBlockLoaded(pos)) {
            f = world.getCurrentMoonPhaseFactor();
            i = (long)((float)world.getChunkFromBlockCoords(pos).getInhabitedTime() * pollution);
        }
        return new DifficultyInstance(world.getDifficulty(), world.getWorldTime(), i, f);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load evt) {
        IWorldPollution pollution;
        if (!evt.getWorld().isRemote && evt.getWorld().hasCapability(WorldPollutionCapability.POLLUTION, null) && (pollution = (IWorldPollution)evt.getWorld().getCapability(WorldPollutionCapability.POLLUTION, null)) != null) {
            ChunkPos pos = evt.getChunk().getPos();
            if (evt.getData().hasKey("bwm_pollution")) {
                NBTTagCompound tag = evt.getData().getCompoundTag("bwm_pollution");
                pollution.readNBT(pos, tag);
            } else {
                pollution.setPollution(pos, 0.0f);
                pollution.setLeafCount(pos, (byte)0);
            }
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkDataEvent.Save evt) {
        ChunkPos pos;
        IWorldPollution pollution;
        if (!evt.getWorld().isRemote && evt.getWorld().hasCapability(WorldPollutionCapability.POLLUTION, null) && (pollution = (IWorldPollution)evt.getWorld().getCapability(WorldPollutionCapability.POLLUTION, null)) != null && pollution.getPollution(pos = evt.getChunk().getPos()) > -1.0f) {
            NBTTagCompound tag = evt.getData();
            tag.setTag("bwm_pollution", (NBTBase)pollution.writeNBT(pos, new NBTTagCompound()));
            if (!evt.getChunk().isLoaded()) {
                pollution.removePollution(pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent evt) {
        IWorldPollution pollution;
        World world = evt.world;
        if (world.hasCapability(WorldPollutionCapability.POLLUTION, null) && !evt.world.isRemote && evt.phase == TickEvent.Phase.START && (pollution = (IWorldPollution)world.getCapability(WorldPollutionCapability.POLLUTION, null)) != null) {
            List tiles;
            long time = world.getWorldTime();
            if (time % 24000L == 6000L) {
                pollution.calculateLeafCount();
            }
            if (time % 8000L == 0L) {
                pollution.calculatePollutionSpread();
            } else if (time % 1000L == 0L) {
                pollution.calculatePollutionReduction();
            }
            List list = world.loadedTileEntityList;
            synchronized (list) {
                tiles = world.loadedTileEntityList.stream().filter(tileEntity -> tileEntity.hasCapability(PollutionCapability.POLLUTION, EnumFacing.UP)).collect(Collectors.toList());
            }
            if (!tiles.isEmpty()) {
                for (TileEntity tile : tiles) {
                    IPollutant pollutant = (IPollutant)tile.getCapability(PollutionCapability.POLLUTION, EnumFacing.UP);
                    if (!pollutant.isPolluting()) continue;
                    ChunkPos chunkPos = new ChunkPos(tile.getPos());
                    if (!(pollution.getPollution(chunkPos) > -1.0f)) continue;
                    ChunkPos p = new ChunkPos(tile.getPos());
                    float pollute = pollution.getPollution(p);
                    pollution.setPollution(p, pollute + pollutant.getPollutionRate());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        ChunkPos pos;
        float pollute;
        IWorldPollution pollution;
        EntityPlayerMP player;
        if (evt.player instanceof EntityPlayerMP && evt.phase == TickEvent.Phase.END && (player = (EntityPlayerMP)evt.player).getEntityWorld().hasCapability(WorldPollutionCapability.POLLUTION, null) && (pollution = (IWorldPollution)player.getEntityWorld().getCapability(WorldPollutionCapability.POLLUTION, null)) != null && !player.capabilities.isCreativeMode && this.isRaining(player.getEntityWorld(), player.getPosition()) && player.getEntityWorld().canSeeSky(player.getPosition()) && (pollute = pollution.getPollution(pos = new ChunkPos(player.getPosition()))) > 6000.0f && player.getEntityWorld().getWorldTime() % 20L == 0L && !PlayerHelper.hasFullSet((EntityPlayer)player, ItemSoulforgeArmor.class)) {
            player.attackEntityFrom((DamageSource)BWDamageSource.acidRain, 1.0f);
        }
    }

    @SubscribeEvent
    public void attachWorldCapability(AttachCapabilitiesEvent<World> evt) {
        final World world = (World)evt.getObject();
        if (!world.isRemote) {
            evt.addCapability(new ResourceLocation("betterwithmods", "world_pollution"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IWorldPollution instance;
                {
                    this.instance = new WorldPollutionCapability.Default(world);
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == WorldPollutionCapability.POLLUTION;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == WorldPollutionCapability.POLLUTION ? WorldPollutionCapability.POLLUTION.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return new NBTTagCompound();
                }

                public void deserializeNBT(NBTTagCompound tag) {
                }
            });
        }
    }

    @SubscribeEvent
    public void attachPollutantCapability(AttachCapabilitiesEvent<TileEntity> evt) {
        TileEntity tile = (TileEntity)evt.getObject();
        if (tile instanceof TileEntityFurnace) {
            final TileEntityFurnace furnace = (TileEntityFurnace)tile;
            evt.addCapability(new ResourceLocation("betterwithmods", "furnace_pollution"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IPollutant instance;
                {
                    this.instance = new CapabilityFurnacePollution(furnace);
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == PollutionCapability.POLLUTION;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == PollutionCapability.POLLUTION ? PollutionCapability.POLLUTION.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return new NBTTagCompound();
                }

                public void deserializeNBT(NBTTagCompound tag) {
                }
            });
        }
    }

    private boolean isRaining(World world, BlockPos pos) {
        return world.isRaining() && world.getBiome(pos).canRain();
    }

    public float getPollutionStat(World world, ChunkPos pos) {
        if (world.hasCapability(WorldPollutionCapability.POLLUTION, null)) {
            IWorldPollution pollution = (IWorldPollution)world.getCapability(WorldPollutionCapability.POLLUTION, null);
            return pollution.getPollution(pos);
        }
        return -1.0f;
    }

    public byte getLeafStat(World world, ChunkPos pos) {
        if (world.hasCapability(WorldPollutionCapability.POLLUTION, null)) {
            return ((IWorldPollution)world.getCapability(WorldPollutionCapability.POLLUTION, null)).getLeafCount(pos);
        }
        return -1;
    }
}

