/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.industry.pollution;

import betterwithmods.module.industry.pollution.Pollution;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class CommandCheckPollution
extends CommandBase {
    public String getName() {
        return "checkPollution";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public String getUsage(ICommandSender sender) {
        return "bwm.checkPollution.usage";
    }

    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = server.getEntityWorld();
        ChunkPos pos = new ChunkPos(sender.getPosition());
        Chunk chunk = world.getChunkProvider().getLoadedChunk(pos.x, pos.z);
        if (chunk != null && chunk.isLoaded()) {
            ArrayList<String> information = new ArrayList<String>();
            this.providePollutionInformation(information, world, pos);
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    Chunk ch;
                    if (x * x == z * z || (ch = world.getChunkProvider().getLoadedChunk(pos.x + x, pos.z + z)) == null || !ch.isLoaded()) continue;
                    this.providePollutionInformation(information, world, ch.getPos());
                }
            }
            if (!information.isEmpty()) {
                information.forEach(s -> sender.sendMessage((ITextComponent)new TextComponentString(s)));
            } else {
                sender.sendMessage((ITextComponent)new TextComponentString("Pollution data for chunk [" + pos.x + ", " + pos.z + "] somehow empty."));
            }
        }
    }

    private void providePollutionInformation(List<String> addTo, World world, ChunkPos from) {
        float pollution = Pollution.handler.getPollutionStat(world, from);
        if (pollution > -1.0f) {
            String info = "Chunk [" + from.x + ", " + from.z + "] pollution: " + String.format("%.2f", Float.valueOf(pollution)) + " Leaf count: " + Pollution.handler.getLeafStat(world, from);
            addTo.add(info);
        }
    }
}

