/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world.stumping;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class PlacedCapability
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=PlacedCapability.class)
    public static Capability<PlacedCapability> PLACED_CAPABILITY = null;
    private Set<BlockPos> placed = Sets.newHashSet();

    public Set<BlockPos> getPlaced() {
        return this.placed;
    }

    public boolean addPlaced(BlockPos pos) {
        return this.placed.add(pos);
    }

    public boolean addAll(BlockPos[] pos) {
        return this.placed.addAll(Arrays.asList(pos));
    }

    public boolean isPlaced(BlockPos pos) {
        return this.placed.contains(pos);
    }

    public void removePlaced(BlockPos pos) {
        this.placed.remove(pos);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == PLACED_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)PLACED_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (BlockPos pos : this.placed) {
            NBTTagLong p = new NBTTagLong(pos.toLong());
            list.appendTag((NBTBase)p);
        }
        tag.setTag("placed", (NBTBase)list);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.hasKey("placed")) {
            this.placed.clear();
            NBTTagList list = nbt.getTagList("placed", 4);
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagLong p = (NBTTagLong)list.get(i);
                this.placed.add(BlockPos.fromLong((long)p.getLong()));
            }
        }
    }

    public static class Storage
    implements Capability.IStorage<PlacedCapability> {
        @Nullable
        public NBTBase writeNBT(Capability<PlacedCapability> capability, PlacedCapability instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<PlacedCapability> capability, PlacedCapability instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }
}

