/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world.spawn;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class SpawnSaving
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=SpawnSaving.class)
    public static Capability<SpawnSaving> SPAWN_CAP = null;
    private BlockPos pos;

    public static Optional<SpawnSaving> getCapability(EntityPlayer player) {
        if (player.hasCapability(SPAWN_CAP, null)) {
            return Optional.ofNullable(player.getCapability(SPAWN_CAP, null));
        }
        return Optional.empty();
    }

    public SpawnSaving() {
    }

    public SpawnSaving(EntityPlayer player) {
        this.pos = player.world.getSpawnPoint();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == SPAWN_CAP;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == SPAWN_CAP) {
            return (T)SPAWN_CAP.cast((Object)this);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setLong("spawn", this.pos.toLong());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.pos = BlockPos.fromLong((long)nbt.getLong("spawn"));
    }

    public static class Storage
    implements Capability.IStorage<SpawnSaving> {
        @Nullable
        public NBTBase writeNBT(Capability<SpawnSaving> capability, SpawnSaving instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<SpawnSaving> capability, SpawnSaving instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }
}

