/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world.spawn;

import betterwithmods.BWMod;
import betterwithmods.module.Feature;
import betterwithmods.module.GlobalConfig;
import betterwithmods.module.hardcore.world.spawn.SpawnSaving;
import betterwithmods.util.player.PlayerHelper;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class HCSpawn
extends Feature {
    public static final Random RANDOM = new Random();
    public static int HARDCORE_SPAWN_RADIUS;
    public static int HARDCORE_SPAWN_COOLDOWN_RADIUS;
    public static int HARDCORE_SPAWN_COOLDOWN;
    public static int HARDCORE_SPAWN_MAX_ATTEMPTS;
    public static ResourceLocation PLAYER_SPAWN_POSITION;

    public static void setSpawn(EntityPlayer player, BlockPos pos) {
        SpawnSaving.getCapability(player).ifPresent(cap -> cap.setPos(pos));
        player.setSpawnPoint(pos, true);
    }

    public static BlockPos getSpawn(EntityPlayer player) {
        return SpawnSaving.getCapability(player).map(SpawnSaving::getPos).orElse(player.world.getSpawnPoint());
    }

    public static BlockPos getRandomPoint(World world, BlockPos origin, int spawnFuzz) {
        BlockPos ret = origin;
        double fuzzVar = MathHelper.getInt((Random)RANDOM, (int)0, (int)spawnFuzz);
        double angle = MathHelper.nextDouble((Random)RANDOM, (double)0.0, (double)360.0);
        double customX = -Math.sin(angle) * fuzzVar;
        double customZ = Math.cos(angle) * fuzzVar;
        ret = ret.add((double)MathHelper.floor((double)customX) + 0.5, 1.5, (double)MathHelper.floor((double)customZ) + 0.5);
        ret = world.getTopSolidOrLiquidBlock(ret);
        return ret;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(SpawnSaving.class, (Capability.IStorage)new SpawnSaving.Storage(), SpawnSaving::new);
    }

    @Override
    public void setupConfig() {
        HARDCORE_SPAWN_RADIUS = this.loadPropInt("Hardcore Spawn Radius", "Radius from original spawn which you will be randomly spawned", 2000);
        HARDCORE_SPAWN_COOLDOWN_RADIUS = this.loadPropInt("Hardcore Spawn Cooldown Radius", "Radius from your previous spawn you will spawn if you die during a cooldown period", 100);
        HARDCORE_SPAWN_COOLDOWN = this.loadPropInt("Hardcore Spawn Cooldown Ticks", "Amount of time after a HCSpawn which you will continue to spawn in the same area", 12000);
    }

    @Override
    public String getFeatureDescription() {
        return "Makes it so death is an actual issue as you will spawn randomly within a 2000 block radius of your original spawn. Compasses still point to original spawn.";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @SubscribeEvent
    public void randomRespawn(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        if (event.getEntity().getEntityWorld().getWorldType() == WorldType.FLAT) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        if (PlayerHelper.isSurvival((EntityPlayer)player)) {
            int radius;
            int timeSinceDeath = player.getStatFile().readStat(StatList.TIME_SINCE_DEATH);
            boolean isNew = timeSinceDeath >= HARDCORE_SPAWN_COOLDOWN;
            BlockPos currentSpawn = isNew ? player.world.getSpawnPoint() : HCSpawn.getSpawn((EntityPlayer)player);
            int n = radius = isNew ? HARDCORE_SPAWN_RADIUS : HARDCORE_SPAWN_COOLDOWN_RADIUS;
            if (GlobalConfig.debug) {
                player.sendMessage((ITextComponent)new TextComponentString(String.format("Spawn: %s, %s, %s, %s", isNew, currentSpawn, radius, timeSinceDeath)));
            }
            BlockPos newPos = this.getRespawnPoint((EntityPlayer)player, currentSpawn, radius);
            HCSpawn.setSpawn((EntityPlayer)player, newPos);
            player.setSpawnPoint(newPos, true);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.player.isDead) {
            event.player.respawnPlayer();
        }
    }

    private BlockPos getRespawnPoint(EntityPlayer player, BlockPos spawnPoint, int spawnFuzz) {
        World world = player.getEntityWorld();
        BlockPos ret = spawnPoint;
        if (!world.provider.isNether()) {
            boolean found = false;
            for (int tryCounter = 0; tryCounter < HARDCORE_SPAWN_MAX_ATTEMPTS; ++tryCounter) {
                ret = HCSpawn.getRandomPoint(world, spawnPoint, spawnFuzz);
                int cmp = ret.getY() - world.provider.getAverageGroundLevel();
                Material check = world.getBlockState(ret).getMaterial();
                IBlockState state = world.getBlockState(ret.up());
                if (cmp < 0 || check.isLiquid() || !state.getBlock().canSpawnInBlock()) continue;
                found = true;
                break;
            }
            if (!found) {
                BWMod.logger.info("New respawn point could not be found.");
            }
        }
        return ret;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(PLAYER_SPAWN_POSITION, (ICapabilityProvider)new SpawnSaving((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public void clone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            HCSpawn.setSpawn(event.getEntityPlayer(), HCSpawn.getSpawn(event.getOriginal()));
        }
    }

    static {
        HARDCORE_SPAWN_MAX_ATTEMPTS = 20;
        PLAYER_SPAWN_POSITION = new ResourceLocation("betterwithmods", "spawn_position");
    }
}

