/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.world.BWMapGenVillage;
import betterwithmods.common.world.gen.village.Blacksmiths;
import betterwithmods.common.world.gen.village.Butchery;
import betterwithmods.common.world.gen.village.Church;
import betterwithmods.common.world.gen.village.House;
import betterwithmods.common.world.gen.village.Hut;
import betterwithmods.common.world.gen.village.Hut2;
import betterwithmods.common.world.gen.village.Library;
import betterwithmods.common.world.gen.village.Well;
import betterwithmods.common.world.gen.village.field.BWField1;
import betterwithmods.common.world.gen.village.field.BWField2;
import betterwithmods.module.Feature;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class HCVillages
extends Feature {
    public static AtomicInteger semiabandonedRadius = new AtomicInteger();
    public static AtomicInteger normalRadius = new AtomicInteger();
    public static boolean disableAllComplexBlocks;
    public static boolean disableVillagerSpawning;
    public static boolean disableIronGolems;

    @Override
    public String getFeatureDescription() {
        return "Makes it so villages with in the reaches of the spawn zone are abandoned and gradually gain more resources the further out. What this means to be gained by the player.";
    }

    @Override
    public void setupConfig() {
        semiabandonedRadius.set(this.loadPropInt("Semi-Abandoned Village Radius", "Block radius from 0,0 at which villages are now semi-abandoned, all villages inside this radius are abandoned", 2000));
        normalRadius.set(this.loadPropInt("Normal Village Radius", "Block radius from 0,0 at which villages are now normal, all villages in between this and semi-abandoned are semi-abandoned", 3000));
        disableAllComplexBlocks = this.loadPropBool("Disable All Complex Blocks", "Removes any and all useful blocks from villages, including ladders, stairs, tables and more", false);
        disableVillagerSpawning = this.loadPropBool("Replace Villager Spawning with Nitwits", "Replaces all villager spawns with Nitwits, which have no trades", true);
        disableIronGolems = this.loadPropBool("Disable Village Iron Golem Spawns", "WARNING: Stops all non-player created Iron Golem Spawns", true);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new BWField1());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new BWField2());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Butchery());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Blacksmiths());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Church());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new House());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Hut());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Hut2());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new Library());
        MapGenStructureIO.registerStructure(BWMapGenVillage.AbandonedStart.class, (String)new ResourceLocation("betterwithmods", "BWAbandonedStart").toString());
        MapGenStructureIO.registerStructureComponent(BWField1.class, (String)new ResourceLocation("betterwithmods", "BWField1").toString());
        MapGenStructureIO.registerStructureComponent(BWField2.class, (String)new ResourceLocation("betterwithmods", "BWField2").toString());
        MapGenStructureIO.registerStructureComponent(Blacksmiths.class, (String)new ResourceLocation("betterwithmods", "Blacksmiths").toString());
        MapGenStructureIO.registerStructureComponent(Butchery.class, (String)new ResourceLocation("betterwithmods", "Butchery").toString());
        MapGenStructureIO.registerStructureComponent(Church.class, (String)new ResourceLocation("betterwithmods", "Church").toString());
        MapGenStructureIO.registerStructureComponent(House.class, (String)new ResourceLocation("betterwithmods", "House").toString());
        MapGenStructureIO.registerStructureComponent(Hut.class, (String)new ResourceLocation("betterwithmods", "Hut").toString());
        MapGenStructureIO.registerStructureComponent(Hut2.class, (String)new ResourceLocation("betterwithmods", "Hut2").toString());
        MapGenStructureIO.registerStructureComponent(Library.class, (String)new ResourceLocation("betterwithmods", "Library").toString());
        MapGenStructureIO.registerStructureComponent(Well.class, (String)new ResourceLocation("betterwithmods", "Well").toString());
    }

    @SubscribeEvent
    public void biomeSpecificVillage(BiomeEvent.GetVillageBlockID event) {
        if (event.getOriginal() == BWMBlocks.WOOD_TABLE.getDefaultState()) {
            event.setReplacement(event.getOriginal().withProperty((IProperty)BlockPlanks.VARIANT, (Comparable)this.plankFromBiome(event.getBiome())));
        }
        if (event.getOriginal() == Blocks.DIRT && BiomeDictionary.hasType((Biome)event.getBiome(), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            event.setReplacement(Blocks.SAND.getDefaultState());
        }
    }

    public BlockPlanks.EnumType plankFromBiome(Biome biome) {
        if (biome == null) {
            return BlockPlanks.EnumType.OAK;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.TAIGA)) {
            return BlockPlanks.EnumType.SPRUCE;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.FOREST)) {
            return BlockPlanks.EnumType.OAK;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.ROOFED_FOREST)) {
            return BlockPlanks.EnumType.OAK;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.JUNGLE)) {
            return BlockPlanks.EnumType.JUNGLE;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.BIRCH_FOREST)) {
            return BlockPlanks.EnumType.BIRCH;
        }
        if (BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.SAVANNA) || BiomeDictionary.areSimilar((Biome)biome, (Biome)Biomes.DESERT)) {
            return BlockPlanks.EnumType.ACACIA;
        }
        return BlockPlanks.EnumType.OAK;
    }

    @SubscribeEvent
    public void onGenerate(InitMapGenEvent event) {
        if (event.getType() == InitMapGenEvent.EventType.VILLAGE) {
            event.setNewGen((MapGenBase)new BWMapGenVillage());
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        EntityIronGolem golem;
        if (!disableIronGolems) {
            return;
        }
        if (event.getEntity() instanceof EntityIronGolem && !(golem = (EntityIronGolem)event.getEntity()).isPlayerCreated()) {
            event.setCanceled(true);
        }
    }

    @Override
    public boolean hasTerrainSubscriptions() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

