/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world;

import betterwithmods.BWMod;
import betterwithmods.module.ConfigHelper;
import betterwithmods.module.Feature;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.FluidUtils;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCBuckets
extends Feature {
    private static List<String> fluidWhitelist;
    private static List<ResourceLocation> fluidcontainerBacklist;
    private static List<Integer> dimensionBlacklist;

    @Override
    public String getFeatureDescription() {
        return "Makes it so water buckets cannot move an entire source block, making water a more valuable resource";
    }

    @Override
    public void setupConfig() {
        dimensionBlacklist = Ints.asList((int[])this.loadPropIntList("Dimension Black List", "A List of dimension ids in which water buckets will work normally. This is done in the End by default to make Enderman Farms actually reasonable to create.", new int[]{DimensionType.THE_END.getId()}));
        fluidWhitelist = Lists.newArrayList((Object[])this.loadPropStringList("Fluid Whitelist", "List of fluids that will be handled by HCBuckets.", new String[]{FluidRegistry.WATER.getName(), "swamp_water", "milk", "stagnant_water", "acid", "sludge", "ale", "alewort", "applejuice", "cider", "grapejuice", "honey", "ironberryjuice", "ironwine", "mead", "oliveoil", "wildberryjuice", "wildberrywine", "wine", "blood", "purpleslime"}));
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        fluidcontainerBacklist = ConfigHelper.loadPropRLList("Fluid container blacklist", this.configCategory, "Blacklist itemstacks from being effected by HCBuckets", new String[]{"thermalcultivation:watering_can"});
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void onInteractFluidHandlerItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        IFluidHandlerItem handlerItem = FluidUtil.getFluidHandler((ItemStack)stack);
        if (handlerItem != null) {
            if (stack.getItem() instanceof ItemBucket) {
                return;
            }
            if (fluidcontainerBacklist.contains(stack.getItem().getRegistryName())) {
                return;
            }
            FluidStack contained = FluidUtil.getFluidContained((ItemStack)stack);
            RayTraceResult raytraceresult = stack.getItem().rayTrace(event.getWorld(), event.getEntityPlayer(), contained == null);
            ActionResult actionResult = ForgeEventFactory.onBucketUse((EntityPlayer)event.getEntityPlayer(), (World)event.getWorld(), (ItemStack)stack, (RayTraceResult)raytraceresult);
            if (actionResult != null && actionResult.getType() == EnumActionResult.SUCCESS && stack != actionResult.getResult()) {
                event.getEntityPlayer().setHeldItem(event.getHand(), (ItemStack)actionResult.getResult());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onUseFluidContainer(FillBucketEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getTarget() != null) {
            ItemStack container = event.getEmptyBucket();
            RayTraceResult raytraceresult = event.getTarget();
            BlockPos pos = raytraceresult.getBlockPos();
            World world = event.getWorld();
            EntityPlayer player = event.getEntityPlayer();
            if (!PlayerHelper.isSurvival(player)) {
                return;
            }
            if (fluidcontainerBacklist.contains(container.getItem().getRegistryName())) {
                return;
            }
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)container);
            if (dimensionBlacklist.contains(world.provider.getDimension())) {
                return;
            }
            if (fluidStack != null && !fluidWhitelist.contains(fluidStack.getFluid().getName())) {
                return;
            }
            FluidActionResult result = FluidUtils.tryPickUpFluid(container, player, world, pos, raytraceresult.sideHit);
            if (result.isSuccess()) {
                if (player.getCooldownTracker().hasCooldown(container.getItem())) {
                    event.setCanceled(true);
                    return;
                }
                ItemStack filledContainer = result.getResult();
                FluidStack filledFluidStack = FluidUtil.getFluidContained((ItemStack)filledContainer);
                if (filledFluidStack != null && !fluidWhitelist.contains(filledFluidStack.getFluid().getName())) {
                    event.setResult(Event.Result.DENY);
                    return;
                }
                event.setResult(Event.Result.ALLOW);
                event.setFilledBucket(result.getResult());
                player.getCooldownTracker().setCooldown(container.getItem(), 20);
            } else {
                BlockPos offset = pos.offset(raytraceresult.sideHit);
                IBlockState state = world.getBlockState(offset);
                if (state.getMaterial().isReplaceable()) {
                    FluidActionResult placeResult;
                    if (fluidStack != null && fluidStack.amount == 1000 && (placeResult = FluidUtils.tryPlaceFluid(player, world, offset, container, fluidStack)).isSuccess()) {
                        event.setResult(Event.Result.ALLOW);
                        event.setFilledBucket(placeResult.getResult());
                    }
                } else if (!state.getMaterial().isOpaque()) {
                    event.setCanceled(true);
                }
            }
            if (GlobalConfig.debug) {
                event.getEntityPlayer().sendMessage((ITextComponent)new TextComponentTranslation("FillBucketEvent: %s,%s,%s,%s", new Object[]{event.getTarget().getBlockPos(), event.getTarget().typeOfHit, event.getEmptyBucket() != null ? event.getEmptyBucket().getDisplayName() : null, event.getFilledBucket() != null ? event.getFilledBucket().getDisplayName() : null}));
                BWMod.getLog().info("FillBucketEvent: {}, {}, {}", (Object)event.getTarget(), (Object)event.getEmptyBucket(), (Object)event.getFilledBucket());
            }
        }
    }
}

