/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.module.Feature;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCSeeds
extends Feature {
    private static final Random RANDOM = new Random();
    public static Set<ItemStack> SEED_BLACKLIST = Sets.newHashSet((Object[])new ItemStack[]{new ItemStack(Items.WHEAT_SEEDS)});
    public static Set<IBlockState> BLOCKS_TO_STOP = Sets.newHashSet();
    private static boolean stopZombieCropLoot;
    private static Predicate<IBlockState> STOP_SEEDS;

    @Override
    public String getFeatureDescription() {
        return "Requires Tilling the ground with a hoe to get seeds.";
    }

    @Override
    public void setupConfig() {
        stopZombieCropLoot = this.loadPropBool("Stop Zombie Crop Loot", "Stops Zombies from dropping potatoes or carrots", true);
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (STOP_SEEDS.test(event.getState())) {
            event.getDrops().clear();
        }
    }

    public NonNullList<ItemStack> getDrops(boolean isGrass, int fortune) {
        if (RANDOM.nextInt(8) != 0) {
            return NonNullList.create();
        }
        ItemStack seed = ForgeHooks.getGrassSeed((Random)RANDOM, (int)0);
        if (SEED_BLACKLIST.stream().anyMatch(s -> InvUtils.matches(s, seed)) || seed.isEmpty() || !isGrass && seed.getItem().equals(Item.getItemFromBlock((Block)BWMBlocks.HEMP))) {
            return NonNullList.create();
        }
        return NonNullList.withSize((int)1, (Object)seed);
    }

    @SubscribeEvent
    public void onHoe(UseHoeEvent e) {
        IBlockState state;
        BlockPos pos;
        if (e.getResult() == Event.Result.DENY) {
            return;
        }
        World world = e.getWorld();
        if (!world.isRemote && world.isAirBlock((pos = e.getPos()).up()) && ((state = world.getBlockState(pos)).getBlock() instanceof BlockGrass || state.getBlock() instanceof BlockDirt)) {
            InvUtils.ejectStackWithOffset(world, pos.up(), this.getDrops(state.getBlock() instanceof BlockGrass, 0));
        }
    }

    @SubscribeEvent
    public void mobDrop(LivingDropsEvent e) {
        if (!stopZombieCropLoot || !(e.getEntityLiving() instanceof EntityZombie)) {
            return;
        }
        Iterator iter = e.getDrops().iterator();
        while (iter.hasNext()) {
            EntityItem item = (EntityItem)iter.next();
            ItemStack stack = item.getItem();
            if (!BWOreDictionary.hasPrefix(stack, "crop")) continue;
            iter.remove();
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        STOP_SEEDS = state -> {
            Block block = state.getBlock();
            return BLOCKS_TO_STOP.contains(state) || block instanceof BlockTallGrass || block instanceof BlockDoublePlant && (state.getValue((IProperty)BlockDoublePlant.VARIANT) == BlockDoublePlant.EnumPlantType.GRASS || state.getValue((IProperty)BlockDoublePlant.VARIANT) == BlockDoublePlant.EnumPlantType.FERN);
        };
    }
}

