/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWRegistry;
import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.common.penalties.GloomPenalties;
import betterwithmods.common.penalties.GloomPenalty;
import betterwithmods.common.penalties.attribute.BWMAttributes;
import betterwithmods.module.Feature;
import betterwithmods.network.BWNetwork;
import betterwithmods.network.messages.MessageGloom;
import betterwithmods.util.StackIngredient;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;

public class HCGloom
extends Feature {
    private static final List<SoundEvent> sounds = Lists.newArrayList((Object[])new SoundEvent[]{SoundEvents.ENTITY_LIGHTNING_THUNDER, SoundEvents.ENTITY_ENDERMEN_TELEPORT, SoundEvents.ENTITY_ENDERMEN_SCREAM, SoundEvents.ENTITY_SILVERFISH_AMBIENT, SoundEvents.ENTITY_WOLF_GROWL});
    @CapabilityInject(value=Gloom.class)
    public static Capability<Gloom> GLOOM_CAPABILITY;
    public static GloomPenalties PENALTIES;
    private static Set<Integer> dimensionWhitelist;
    private static Ingredient gloomOverrideItems;
    private static ResourceLocation PLAYER_GLOOM;

    public static int getGloomTime(EntityPlayer player) {
        Gloom gloom = HCGloom.getGloom((Entity)player);
        if (gloom != null) {
            return gloom.getGloom();
        }
        return 0;
    }

    public static void incrementGloomTime(EntityPlayerMP player) {
        int time = HCGloom.getGloomTime((EntityPlayer)player);
        HCGloom.setGloomTick(player, time + 1);
    }

    public static void setGloomTick(EntityPlayerMP player, int value) {
        Gloom gloom = HCGloom.getGloom((Entity)player);
        if (gloom != null) {
            gloom.setGloom(value);
            BWNetwork.INSTANCE.sendTo((IMessage)new MessageGloom(player.getUniqueID().toString(), value), player);
        }
    }

    public static Gloom getGloom(Entity entity) {
        if (entity.hasCapability(GLOOM_CAPABILITY, null)) {
            return (Gloom)entity.getCapability(GLOOM_CAPABILITY, null);
        }
        return null;
    }

    @Override
    public void setupConfig() {
        dimensionWhitelist = Sets.newHashSet((Object[])ArrayUtils.toObject((int[])this.loadPropIntList("Gloom Dimension Whitelist", "Gloom is only available in these dimensions", new int[]{0})));
        PENALTIES = new GloomPenalties();
        BWRegistry.PENALTY_HANDLERS.add(PENALTIES);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(Gloom.class, (Capability.IStorage)new CapabilityGloom(), Gloom::new);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        gloomOverrideItems = StackIngredient.fromStacks(this.loadItemStackArray("Gloom Override Items", "Items in this list will override the gloom effect while held in your hand, this allows support for Dynamic Lightning and similar. Add one item per line  (ex minecraft:torch:0)", new ItemStack[0]));
    }

    @SubscribeEvent
    public void clone(PlayerEvent.Clone event) {
        Gloom o = HCGloom.getGloom((Entity)event.getOriginal());
        Gloom n = HCGloom.getGloom((Entity)event.getEntityPlayer());
        if (o != null && n != null) {
            n.deserializeNBT(o.serializeNBT());
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !event.getCapabilities().containsKey(PLAYER_GLOOM)) {
            event.addCapability(PLAYER_GLOOM, (ICapabilityProvider)new Gloom());
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            HCGloom.setGloomTick((EntityPlayerMP)e.player, 0);
        }
    }

    @SubscribeEvent
    public void inDarkness(TickEvent.PlayerTickEvent e) {
        EntityPlayer player = e.player;
        World world = player.getEntityWorld();
        if (!PlayerHelper.isSurvival(player) || !dimensionWhitelist.contains(world.provider.getDimension())) {
            return;
        }
        if (e.player instanceof EntityPlayerMP) {
            EntityPlayerMP playermp = (EntityPlayerMP)player;
            if (!world.isRemote) {
                int light = world.getLight(playermp.getPosition().up());
                int tick = HCGloom.getGloomTime((EntityPlayer)playermp);
                if (PlayerHelper.isHolding((EntityPlayer)playermp, gloomOverrideItems)) {
                    light = 15;
                }
                if (player.isPotionActive(MobEffects.NIGHT_VISION)) {
                    light = 15;
                }
                if (light <= 0) {
                    HCGloom.incrementGloomTime(playermp);
                } else if (tick != 0) {
                    HCGloom.setGloomTick(playermp, 0);
                }
            }
            if (world.getTotalWorldTime() % 40L == 0L && world.rand.nextInt(2) == 0 && BWRegistry.PENALTY_HANDLERS.attackedByGrue(player)) {
                player.attackEntityFrom((DamageSource)BWDamageSource.gloom, 2.0f);
            }
        }
        if (world.isRemote) {
            float spooked = BWRegistry.PENALTY_HANDLERS.getSpooked(player);
            GloomPenalty most = (GloomPenalty)PENALTIES.getMostSevere();
            if (world.rand.nextDouble() <= (double)spooked) {
                player.playSound(SoundEvents.AMBIENT_CAVE, 0.7f, 0.8f + world.rand.nextFloat() * 0.2f);
                if (most != null && spooked >= most.getFloat(BWMAttributes.SPOOKED).getValue().floatValue()) {
                    if (world.rand.nextInt(5) == 0) {
                        player.playSound(sounds.get(world.rand.nextInt(sounds.size())), 0.7f, 0.8f + world.rand.nextFloat() * 0.2f);
                    }
                    player.addPotionEffect(new PotionEffect(MobEffects.BLINDNESS, 100, 1, false, false));
                }
            }
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        float spooked = BWRegistry.PENALTY_HANDLERS.getSpooked(event.getEntity());
        GloomPenalty most = (GloomPenalty)PENALTIES.getMostSevere();
        if (most != null && spooked >= most.getFloat(BWMAttributes.SPOOKED).getValue().floatValue()) {
            float change = -((float)HCGloom.getGloomTime(event.getEntity()) / 100000.0f);
            event.setNewfov(event.getFov() + change);
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Be afraid of the dark...";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    static {
        PLAYER_GLOOM = new ResourceLocation("betterwithmods", "gloom");
    }

    public static class Gloom
    implements ICapabilitySerializable<NBTTagCompound> {
        private int gloom;

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == GLOOM_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)GLOOM_CAPABILITY.cast((Object)this);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.setInteger("gloom", this.gloom);
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt.hasKey("gloom")) {
                this.gloom = nbt.getInteger("gloom");
            }
        }

        public int getGloom() {
            return this.gloom;
        }

        public void setGloom(int gloom) {
            this.gloom = gloom;
        }
    }

    public static class CapabilityGloom
    implements Capability.IStorage<Gloom> {
        @Nullable
        public NBTBase writeNBT(Capability<Gloom> capability, Gloom instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<Gloom> capability, Gloom instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }
}

