/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.penalties.ArmorPenalties;
import betterwithmods.module.Feature;
import betterwithmods.module.ModuleLoader;
import betterwithmods.util.item.StackMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class HCArmor
extends Feature {
    public static ArmorPenalties penalties;
    public static final StackMap<Integer> weights;
    public static boolean shieldRebalance;

    public static float getWeight(ItemStack stack) {
        if (!ModuleLoader.isFeatureEnabled(HCArmor.class)) {
            return 0.0f;
        }
        return weights.get(stack).intValue();
    }

    public static void initWeights() {
        weights.put((Item)Items.CHAINMAIL_HELMET, Short.MAX_VALUE, (Integer)3);
        weights.put((Item)Items.CHAINMAIL_CHESTPLATE, Short.MAX_VALUE, (Integer)4);
        weights.put((Item)Items.CHAINMAIL_LEGGINGS, Short.MAX_VALUE, (Integer)4);
        weights.put((Item)Items.CHAINMAIL_BOOTS, Short.MAX_VALUE, (Integer)2);
        weights.put((Item)Items.IRON_HELMET, Short.MAX_VALUE, (Integer)5);
        weights.put((Item)Items.IRON_CHESTPLATE, Short.MAX_VALUE, (Integer)8);
        weights.put((Item)Items.IRON_LEGGINGS, Short.MAX_VALUE, (Integer)7);
        weights.put((Item)Items.IRON_BOOTS, Short.MAX_VALUE, (Integer)4);
        weights.put((Item)Items.DIAMOND_HELMET, Short.MAX_VALUE, (Integer)5);
        weights.put((Item)Items.DIAMOND_CHESTPLATE, Short.MAX_VALUE, (Integer)8);
        weights.put((Item)Items.DIAMOND_LEGGINGS, Short.MAX_VALUE, (Integer)7);
        weights.put((Item)Items.DIAMOND_BOOTS, Short.MAX_VALUE, (Integer)4);
        weights.put(BWMItems.STEEL_HELMET, Short.MAX_VALUE, (Integer)5);
        weights.put(BWMItems.STEEL_CHEST, Short.MAX_VALUE, (Integer)8);
        weights.put(BWMItems.STEEL_PANTS, Short.MAX_VALUE, (Integer)7);
        weights.put(BWMItems.STEEL_BOOTS, Short.MAX_VALUE, (Integer)4);
        weights.put((Item)Items.GOLDEN_HELMET, Short.MAX_VALUE, (Integer)5);
        weights.put((Item)Items.GOLDEN_CHESTPLATE, Short.MAX_VALUE, (Integer)8);
        weights.put((Item)Items.GOLDEN_LEGGINGS, Short.MAX_VALUE, (Integer)7);
        weights.put((Item)Items.GOLDEN_BOOTS, Short.MAX_VALUE, (Integer)4);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (shieldRebalance) {
            this.addHardcoreRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(Items.SHIELD), new Object[]{"SWS", "WIW", " W ", Character.valueOf('S'), "strapLeather", Character.valueOf('W'), "sidingWood", Character.valueOf('I'), "ingotIron"}).setRegistryName("minecraft:shield"));
        }
        HCArmor.initWeights();
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public void setupConfig() {
        penalties = new ArmorPenalties();
        BWRegistry.PENALTY_HANDLERS.add(penalties);
        shieldRebalance = this.loadPropBool("Shield Rebalance", "Experimental recipes for rebalacing shields", false);
    }

    @Override
    public String getFeatureDescription() {
        return "Gives Armor weight values that effect movement. Changes Entity armor spawning: Zombies only spawn with Iron armor, Skeletons never wear armor.";
    }

    static {
        weights = new StackMap<Integer>(0);
    }
}

