/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.creatures;

import betterwithmods.module.Feature;
import betterwithmods.module.hardcore.creatures.AIAttackRiding;
import betterwithmods.module.hardcore.creatures.AIGrab;
import betterwithmods.module.hardcore.creatures.AIMount;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCSquid
extends Feature {
    @Override
    public String getFeatureDescription() {
        return "Fear the squid...";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void addEntityAI(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntitySquid) {
            EntitySquid squid = (EntitySquid)event.getEntity();
            squid.setNoGravity(true);
            squid.tasks.taskEntries.clear();
            squid.tasks.addTask(2, (EntityAIBase)new AIAttackRiding((EntityLivingBase)squid));
            squid.tasks.addTask(2, (EntityAIBase)new AIMount((EntityLiving)squid, 2));
            squid.tasks.addTask(3, (EntityAIBase)new AIGrab((EntityLiving)squid, 2, 10));
            squid.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)squid, EntityPlayer.class, 100.0f));
            squid.targetTasks.addTask(2, (EntityAIBase)new EntityAIFindEntityNearest((EntityLiving)squid, EntityPlayer.class));
        }
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntitySquid) {
            EntitySquid squid = (EntitySquid)event.getEntityLiving();
            squid.setAir(300);
            if (squid.isRiding() && squid.getRidingEntity() instanceof EntityLivingBase) {
                float f1 = MathHelper.sqrt((double)(squid.motionX * squid.motionX + squid.motionZ * squid.motionZ));
                squid.squidPitch += (-((float)MathHelper.atan2((double)f1, (double)squid.motionY)) * 57.295776f - squid.squidPitch) * 0.5f;
            }
        }
    }

    @SubscribeEvent
    public void onClicked(PlayerInteractEvent.EntityInteractSpecific event) {
    }

    @SubscribeEvent
    public void onDismount(EntityMountEvent event) {
        if (event.getEntityMounting() instanceof EntitySquid && event.isDismounting() && event.getEntityMounting().isEntityAlive()) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }
}

