/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.creatures;

import betterwithmods.module.Feature;
import betterwithmods.util.EntityUtils;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCEndermen
extends Feature {
    @Override
    public String getFeatureDescription() {
        return "Makes Endermen agro in groups and make a thunder noise when they teleport";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @SubscribeEvent
    public void onTeleport(EnderTeleportEvent evt) {
        evt.getEntityLiving().getEntityWorld().playSound(null, evt.getEntityLiving().getPosition(), SoundEvents.ENTITY_LIGHTNING_THUNDER, SoundCategory.HOSTILE, 1.0f, 1.0f);
    }

    @SubscribeEvent
    public void addEntityAI(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof EntityEnderman && !evt.getWorld().isRemote) {
            EntityEnderman entity = (EntityEnderman)evt.getEntity();
            EntityUtils.findFirst((EntityLiving)entity, EntityAIHurtByTarget.class).ifPresent(ai -> {
                ((EntityAIHurtByTarget)ai).entityCallsForHelp = true;
            });
            entity.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)entity, true, new Class[0]));
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

