/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.creatures;

import betterwithmods.module.hardcore.creatures.EntityTentacle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;

public class AIGrab
extends EntityAIBase {
    public EntityLiving rider;
    public EntityLivingBase target;
    public EntityTentacle tentacle;
    private int min;
    private int max;
    private int ticks;

    public AIGrab(EntityLiving rider, int min, int max) {
        this.rider = rider;
        this.min = min;
        this.max = max;
    }

    public void resetTask() {
        if (this.tentacle != null) {
            this.tentacle.setDead();
        }
    }

    public void startExecuting() {
        if (this.tentacle != null) {
            this.tentacle.setDead();
        }
    }

    public boolean shouldExecute() {
        if (this.rider == null || this.rider.isRiding()) {
            return false;
        }
        this.target = this.rider.getAttackTarget();
        if (this.target == null || this.target instanceof EntityPlayer && ((EntityPlayer)this.target).isCreative() || !this.rider.getEntitySenses().canSee((Entity)this.target)) {
            return false;
        }
        double distance = this.rider.getDistanceSq((Entity)this.target);
        return !this.rider.isRiding() && distance > (double)(this.min * this.min) && distance < (double)(this.max * this.max);
    }

    public boolean shouldContinueExecuting() {
        return super.shouldContinueExecuting();
    }

    public void updateTask() {
        if (this.rider.world.isRemote) {
            return;
        }
        if (!this.target.isBeingRidden()) {
            if (this.tentacle == null) {
                this.tentacle = new EntityTentacle(this.rider.world, (EntityLivingBase)this.rider);
                this.rider.world.spawnEntity((Entity)this.tentacle);
            } else {
                ++this.ticks;
                if (this.ticks > 10) {
                    this.tentacle.handleHookRetraction();
                    this.tentacle.setDead();
                    this.tentacle = null;
                    this.ticks = 0;
                }
            }
        }
    }
}

