/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.beacons;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import org.apache.commons.lang3.tuple.Pair;

public class CapabilityBeacon
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=CapabilityBeacon.class)
    public static Capability<CapabilityBeacon> BEACON_CAPABILITY = null;
    private HashMap<Long, Integer> beacons = Maps.newHashMap();

    public void addBeacon(BlockPos pos, int level) {
        this.beacons.put(pos.toLong(), level);
    }

    public void removeBeacon(BlockPos pos) {
        this.beacons.remove(pos.toLong());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == BEACON_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)BEACON_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Long, Integer> entry : this.beacons.entrySet()) {
            list.appendTag((NBTBase)CapabilityBeacon.writeBeaconEntry(entry.getKey(), entry.getValue()));
        }
        tags.setTag("list", (NBTBase)list);
        return tags;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.getTagList("list", 10);
        for (NBTTagCompound tag : list) {
            Pair<Long, Integer> b = CapabilityBeacon.readBeaconEntry(tag);
            this.beacons.put((Long)b.getKey(), (Integer)b.getValue());
        }
    }

    private static NBTTagCompound writeBeaconEntry(Long pos, int level) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setLong("pos", pos.longValue());
        tag.setInteger("level", level);
        return tag;
    }

    private static Pair<Long, Integer> readBeaconEntry(NBTTagCompound tag) {
        return Pair.of((Object)tag.getLong("pos"), (Object)tag.getInteger("level"));
    }

    public BlockPos getClosest(World world, Entity player) {
        if (this.beacons.isEmpty()) {
            return world.getSpawnPoint();
        }
        BlockPos pos = BlockPos.fromLong((long)this.beacons.keySet().stream().min(Comparator.comparingDouble(p -> BlockPos.fromLong((long)p).distanceSq((Vec3i)player.getPosition()))).orElse(world.getSpawnPoint().toLong()));
        return pos;
    }

    public static class Storage
    implements Capability.IStorage<CapabilityBeacon> {
        @Nullable
        public NBTBase writeNBT(Capability<CapabilityBeacon> capability, CapabilityBeacon instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<CapabilityBeacon> capability, CapabilityBeacon instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }
}

