/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks;

import betterwithmods.BWMod;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.module.gameplay.miniblocks.ItemMini;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.gameplay.miniblocks.MiniType;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import betterwithmods.util.StackIngredient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class MiniBlockIngredient
extends BlockIngredient {
    private Ingredient base;
    private MiniType type;
    private ItemStack[] cache = null;

    public MiniBlockIngredient(String type, Ingredient base) {
        super(new ItemStack[0]);
        this.type = MiniType.fromName(type.toLowerCase());
        this.base = base;
    }

    public MiniBlockIngredient(String type, ItemStack stack) {
        this(type, StackIngredient.fromStacks(stack));
    }

    @Override
    public boolean apply(@Nullable ItemStack stack) {
        IBlockState state = ItemMini.getState(stack);
        if (state != null && MiniType.matches(this.type, stack)) {
            ItemStack baseStack = BWMRecipes.getStackFromState(state);
            return this.base.apply(baseStack);
        }
        return false;
    }

    @Override
    public boolean apply(World world, BlockPos pos, @Nullable IBlockState state) {
        if (state != null) {
            RayTraceResult rayTraceResult = new RayTraceResult(new Vec3d((Vec3i)pos).addVector(0.5, 0.5, 0.5), EnumFacing.UP, pos);
            try {
                ItemStack stack = state.getBlock().getPickBlock(state, rayTraceResult, world, pos, null);
                return this.apply(stack);
            }
            catch (NullPointerException e) {
                BWMod.logger.error("The pick-block for {} was invalid with a raytrace or a null player. Please report to the owner of the block.", (Object)state.getBlock().getRegistryName());
            }
        }
        return false;
    }

    @Override
    protected void invalidate() {
        super.invalidate();
        this.cache = null;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    @Nonnull
    public ItemStack[] getMatchingStacks() {
        if (this.cache == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack stack : this.base.getMatchingStacks()) {
                if (stack.isEmpty() || !(stack.getItem() instanceof ItemBlock)) continue;
                IBlockState state = BWMRecipes.getStateFromStack(stack);
                Material material = state.getMaterial();
                if (!MiniBlocks.isValidMini(state)) continue;
                BlockMini blockMini = MiniBlocks.MINI_MATERIAL_BLOCKS.get((Object)this.type).get(material);
                stacks.add(MiniBlocks.fromParent(blockMini, state));
            }
            this.cache = stacks.toArray(new ItemStack[stacks.size()]);
        }
        return this.cache;
    }

    public String toString() {
        return String.format("type:%s parent:%s", this.type.name(), Arrays.toString(this.base.getMatchingStacks()));
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            String type = JsonUtils.getString((JsonObject)json, (String)"minitype");
            Ingredient i = CraftingHelper.getIngredient((JsonElement)JsonUtils.getJsonObject((JsonObject)json, (String)"baseIngredient"), (JsonContext)context);
            return new MiniBlockIngredient(type, i);
        }
    }
}

