/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.api.recipe.impl.RandomCountOutputs;
import betterwithmods.api.recipe.impl.RandomOutput;
import betterwithmods.api.util.IWood;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.registry.block.recipe.BlockDropIngredient;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.SawRecipe;
import betterwithmods.module.Feature;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class SawRecipes
extends Feature {
    private static int plankCount;
    private static int barkCount;
    private static int sawDustCount;

    public SawRecipes() {
        this.canDisable = false;
    }

    @Override
    public void setupConfig() {
        plankCount = this.loadPropInt("Saw Plank Output", "Plank count that is output when a log is chopped by a Saw.", 4);
        barkCount = this.loadPropInt("Saw Bark Output", "Bark count that is output when a log is chopped by a Saw.", 1);
        sawDustCount = this.loadPropInt("Saw sawdust Output", "Sawdust count that is output when a log is chopped by a Saw.", 2);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BWRegistry.WOOD_SAW.addSelfdropRecipe(new ItemStack(Blocks.PUMPKIN));
        BWRegistry.WOOD_SAW.addSelfdropRecipe(new ItemStack(Blocks.VINE));
        BWRegistry.WOOD_SAW.addSelfdropRecipe(new ItemStack((Block)Blocks.YELLOW_FLOWER));
        BWRegistry.WOOD_SAW.addSelfdropRecipe(new ItemStack((Block)Blocks.BROWN_MUSHROOM));
        BWRegistry.WOOD_SAW.addSelfdropRecipe(new ItemStack((Block)Blocks.RED_MUSHROOM));
        BWRegistry.WOOD_SAW.addSelfdropRecipe(new ItemStack(BWMBlocks.ROPE));
        for (int i = 0; i < 9; ++i) {
            BWRegistry.WOOD_SAW.addSelfdropRecipe(new ItemStack((Block)Blocks.RED_FLOWER, 1, i));
        }
        BWRegistry.WOOD_SAW.addRecipe(new SawRecipe(new BlockIngredient(new ItemStack(Blocks.MELON_BLOCK)), new RandomCountOutputs(new RandomOutput(new ItemStack(Items.MELON), 3, 8))));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        for (IWood wood : BWOreDictionary.woods) {
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(wood.getLog(1)), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{wood.getPlank(plankCount), wood.getBark(barkCount), wood.getSawdust(sawDustCount)}));
        }
    }
}

