/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.client.renderer.font;

import betterwithmods.manual.client.renderer.font.FontRenderer;
import gnu.trove.map.TCharIntMap;
import gnu.trove.map.hash.TCharIntHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractFontRenderer
implements FontRenderer {
    private final TCharIntMap CHAR_MAP;
    private final int COLUMNS = this.getResolution() / (this.getCharWidth() + this.getGapU());
    private final float U_SIZE = (float)this.getCharWidth() / (float)this.getResolution();
    private final float V_SIZE = (float)this.getCharHeight() / (float)this.getResolution();
    private final float U_STEP = (float)(this.getCharWidth() + this.getGapU()) / (float)this.getResolution();
    private final float V_STEP = (float)(this.getCharHeight() + this.getGapV()) / (float)this.getResolution();

    protected AbstractFontRenderer() {
        this.CHAR_MAP = new TCharIntHashMap();
        CharSequence chars = this.getCharacters();
        for (int index = 0; index < chars.length(); ++index) {
            this.CHAR_MAP.put(chars.charAt(index), index);
        }
    }

    @Override
    public void drawString(CharSequence value) {
        this.drawString(value, value.length());
    }

    @Override
    public void drawString(CharSequence value, int maxChars) {
        GlStateManager.pushMatrix();
        GlStateManager.depthMask((boolean)false);
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.getTextureLocation());
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        float tx = 0.0f;
        int end = Math.min(maxChars, value.length());
        for (int i = 0; i < end; ++i) {
            char ch = value.charAt(i);
            this.drawChar(tx, ch, buffer);
            tx += (float)(this.getCharWidth() + this.getGapU());
        }
        tessellator.draw();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.popMatrix();
    }

    protected abstract CharSequence getCharacters();

    protected abstract ResourceLocation getTextureLocation();

    protected abstract int getResolution();

    protected abstract int getGapU();

    protected abstract int getGapV();

    private void drawChar(float x, char ch, BufferBuilder buffer) {
        if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
            return;
        }
        int index = this.getCharIndex(ch);
        int column = index % this.COLUMNS;
        int row = index / this.COLUMNS;
        float u = (float)column * this.U_STEP;
        float v = (float)row * this.V_STEP;
        buffer.pos((double)x, (double)this.getCharHeight(), 0.0).tex((double)u, (double)(v + this.V_SIZE)).endVertex();
        buffer.pos((double)(x + (float)this.getCharWidth()), (double)this.getCharHeight(), 0.0).tex((double)(u + this.U_SIZE), (double)(v + this.V_SIZE)).endVertex();
        buffer.pos((double)(x + (float)this.getCharWidth()), 0.0, 0.0).tex((double)(u + this.U_SIZE), (double)v).endVertex();
        buffer.pos((double)x, 0.0, 0.0).tex((double)u, (double)v).endVertex();
    }

    private int getCharIndex(char ch) {
        if (!this.CHAR_MAP.containsKey(ch)) {
            return this.CHAR_MAP.get('?');
        }
        return this.CHAR_MAP.get(ch);
    }
}

