/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.client.manual.segment.render;

import betterwithmods.manual.api.manual.ImageRenderer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TextureImageRenderer
implements ImageRenderer {
    private final ResourceLocation location;
    private final ImageTexture texture;

    public TextureImageRenderer(ResourceLocation location) {
        this.location = location;
        TextureManager manager = Minecraft.getMinecraft().getTextureManager();
        ITextureObject image = manager.getTexture(location);
        if (image instanceof ImageTexture) {
            this.texture = (ImageTexture)image;
        } else {
            if (image != null && image.getGlTextureId() != -1) {
                TextureUtil.deleteTexture((int)image.getGlTextureId());
            }
            this.texture = new ImageTexture(location);
            manager.loadTexture(location, (ITextureObject)this.texture);
        }
    }

    @Override
    public int getWidth() {
        return this.texture.width;
    }

    @Override
    public int getHeight() {
        return this.texture.height;
    }

    @Override
    public void render(int mouseX, int mouseY) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.location);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)this.texture.height);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)this.texture.width, (float)this.texture.height);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)this.texture.width, (float)0.0f);
        GL11.glEnd();
    }

    private static class ImageTexture
    extends AbstractTexture {
        private final ResourceLocation location;
        private int width = 0;
        private int height = 0;

        public ImageTexture(ResourceLocation location) {
            this.location = location;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadTexture(IResourceManager manager) throws IOException {
            this.deleteGlTexture();
            try (InputStream is = null;){
                IResource resource = manager.getResource(this.location);
                is = resource.getInputStream();
                BufferedImage bi = ImageIO.read(is);
                TextureUtil.uploadTextureImageAllocate((int)this.getGlTextureId(), (BufferedImage)bi, (boolean)false, (boolean)false);
                this.width = bi.getWidth();
                this.height = bi.getHeight();
            }
        }
    }
}

