/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.client.manual.segment;

import betterwithmods.manual.api.manual.ImageRenderer;
import betterwithmods.manual.api.manual.InteractiveImageRenderer;
import betterwithmods.manual.client.manual.Document;
import betterwithmods.manual.client.manual.segment.AbstractSegment;
import betterwithmods.manual.client.manual.segment.InteractiveSegment;
import betterwithmods.manual.client.manual.segment.Segment;
import java.util.Optional;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderSegment
extends AbstractSegment
implements InteractiveSegment {
    private final Segment parent;
    private final String title;
    private final ImageRenderer imageRenderer;
    private int lastX = 0;
    private int lastY = 0;

    public RenderSegment(Segment parent, String title, ImageRenderer imageRenderer) {
        super(parent.getManual());
        this.parent = parent;
        this.title = title;
        this.imageRenderer = imageRenderer;
    }

    @Override
    public Segment parent() {
        return this.parent;
    }

    @Override
    public Optional<String> tooltip() {
        if (this.imageRenderer instanceof InteractiveImageRenderer) {
            return Optional.of(((InteractiveImageRenderer)this.imageRenderer).getTooltip(this.title));
        }
        return Optional.of(this.title);
    }

    @Override
    public boolean onMouseClick(int mouseX, int mouseY) {
        return this.imageRenderer instanceof InteractiveImageRenderer && ((InteractiveImageRenderer)this.imageRenderer).onMouseClick(mouseX - this.lastX, mouseY - this.lastY);
    }

    @Override
    public void notifyHover() {
    }

    @Override
    public int nextY(int indent, int maxWidth, FontRenderer renderer) {
        return this.imageHeight(maxWidth) + (indent > 0 ? Document.lineHeight(renderer) : 0);
    }

    @Override
    public int nextX(int indent, int maxWidth, FontRenderer renderer) {
        return 0;
    }

    @Override
    public Optional<InteractiveSegment> render(int x, int y, int indent, int maxWidth, FontRenderer renderer, int mouseX, int mouseY) {
        int width = this.imageWidth(maxWidth);
        int height = this.imageHeight(maxWidth);
        int xOffset = (maxWidth - width) / 2;
        int yOffset = 2 + (indent > 0 ? Document.lineHeight(renderer) : 0);
        float s = this.scale(maxWidth);
        this.lastX = x + xOffset;
        this.lastY = y + yOffset;
        Optional<InteractiveSegment> hovered = this.checkHovered(mouseX, mouseY, x + xOffset, y + yOffset, width, height);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)(x + xOffset), (float)(y + yOffset), (float)0.0f);
        GlStateManager.scale((float)s, (float)s, (float)s);
        GlStateManager.enableBlend();
        GlStateManager.enableAlpha();
        if (hovered.isPresent()) {
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
            GlStateManager.disableTexture2D();
            GL11.glBegin((int)7);
            GL11.glVertex2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)0.0f, (float)this.imageRenderer.getHeight());
            GL11.glVertex2f((float)this.imageRenderer.getWidth(), (float)this.imageRenderer.getHeight());
            GL11.glVertex2f((float)this.imageRenderer.getWidth(), (float)0.0f);
            GL11.glEnd();
            GlStateManager.enableTexture2D();
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.imageRenderer.render(mouseX - x, mouseY - y);
        GlStateManager.popMatrix();
        return hovered;
    }

    public String toString() {
        return String.format("![%s](%s)", this.title, this.imageRenderer);
    }

    private float scale(int maxWidth) {
        return Math.min(1.0f, (float)maxWidth / (float)this.imageRenderer.getWidth());
    }

    private int imageWidth(int maxWidth) {
        return Math.min(maxWidth, this.imageRenderer.getWidth());
    }

    private int imageHeight(int maxWidth) {
        return MathHelper.ceil((float)((float)this.imageRenderer.getHeight() * this.scale(maxWidth))) + 4;
    }
}

