/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.client.manual.provider;

import betterwithmods.BWMod;
import betterwithmods.manual.api.manual.ImageProvider;
import betterwithmods.manual.api.manual.ImageRenderer;
import betterwithmods.manual.client.manual.segment.render.ItemStackImageRenderer;
import betterwithmods.manual.client.manual.segment.render.MissingItemRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictImageProvider
implements ImageProvider {
    private static final String WARNING_ORE_DICT_MISSING = "betterwithmods.manual.warning.missing.oreDict";

    @Override
    public ImageRenderer getImage(String data) {
        ItemStack[] stacks = (ItemStack[])OreDictionary.getOres((String)data).stream().flatMap(stack -> OreDictImageProvider.getSubtypes(stack).stream()).toArray(ItemStack[]::new);
        if (stacks != null && stacks.length > 0) {
            return new ItemStackImageRenderer(stacks);
        }
        return new MissingItemRenderer(WARNING_ORE_DICT_MISSING);
    }

    private static List<ItemStack> getSubtypes(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return Collections.emptyList();
        }
        if (itemStack.isEmpty()) {
            return Collections.emptyList();
        }
        if (itemStack.getItemDamage() != Short.MAX_VALUE) {
            return Collections.singletonList(itemStack);
        }
        return OreDictImageProvider.getSubtypes(itemStack.getItem(), itemStack.getCount());
    }

    private static List<ItemStack> getSubtypes(Item item, int stackSize) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            NonNullList subItems = NonNullList.create();
            try {
                item.getSubItems(itemTab, subItems);
            }
            catch (LinkageError | RuntimeException e) {
                BWMod.getLog().warn("Caught a crash while getting sub-items of {}", (Object)item, (Object)e);
            }
            for (ItemStack subItem : subItems) {
                if (subItem == null) {
                    BWMod.getLog().warn("Found a null subItem of {}", (Object)item);
                    continue;
                }
                if (subItem.isEmpty()) {
                    BWMod.getLog().warn("Found an empty subItem of {}", (Object)item);
                    continue;
                }
                if (subItem.getCount() != stackSize) {
                    ItemStack subItemCopy = subItem.copy();
                    subItemCopy.setCount(stackSize);
                    itemStacks.add(subItemCopy);
                    continue;
                }
                itemStacks.add(subItem);
            }
        }
        return itemStacks;
    }
}

