/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.items.ItemEnderSpectacles;
import betterwithmods.common.potion.BWPotion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class PotionEventHandler {
    @SubscribeEvent
    public static void onEndermanLook(LivingSetAttackTargetEvent event) {
        EntityLivingBase target = event.getTarget();
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof EntityEnderman && target instanceof EntityPlayer && target.getItemStackFromSlot(EntityEquipmentSlot.HEAD).getItem() instanceof ItemEnderSpectacles) {
            ((EntityEnderman)living).setAttackTarget(null);
        }
    }

    @SubscribeEvent
    public static void onRenderFireOverlay(RenderBlockOverlayEvent e) {
        if (e.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE && e.getPlayer().getEntityWorld().getBlockState(e.getBlockPos()).getBlock() == BWMBlocks.STOKED_FLAME) {
            PotionEventHandler.renderFireInFirstPerson();
            e.setCanceled(true);
        }
    }

    private static void renderFireInFirstPerson() {
        Minecraft mc = Minecraft.getMinecraft();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexbuffer = tessellator.getBuffer();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        GlStateManager.depthFunc((int)519);
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.pushMatrix();
            TextureAtlasSprite textureatlassprite = mc.getTextureMapBlocks().getTextureExtry("betterwithmods:blocks/stoked_fire_layer_0");
            if (textureatlassprite == null) {
                textureatlassprite = mc.getTextureMapBlocks().getMissingSprite();
            }
            mc.getTextureManager().bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
            float f1 = textureatlassprite.getMinU();
            float f2 = textureatlassprite.getMaxU();
            float f3 = textureatlassprite.getMinV();
            float f4 = textureatlassprite.getMaxV();
            GlStateManager.translate((float)((float)(-(i * 2 - 1)) * 0.24f), (float)-0.3f, (float)0.0f);
            GlStateManager.rotate((float)((float)(i * 2 - 1) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            vertexbuffer.pos(-0.5, -0.5, -0.5).tex((double)f2, (double)f4).endVertex();
            vertexbuffer.pos(0.5, -0.5, -0.5).tex((double)f1, (double)f4).endVertex();
            vertexbuffer.pos(0.5, 0.5, -0.5).tex((double)f1, (double)f3).endVertex();
            vertexbuffer.pos(-0.5, 0.5, -0.5).tex((double)f2, (double)f3).endVertex();
            tessellator.draw();
            GlStateManager.popMatrix();
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.depthFunc((int)515);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onHarvestBlock(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null && event.getHarvester().isPotionActive(BWRegistry.POTION_FORTUNE)) {
            PotionEffect effect = event.getHarvester().getActivePotionEffect(BWRegistry.POTION_FORTUNE);
            int level = effect.getAmplifier() + 1;
            if (event.getFortuneLevel() < level) {
                event.getDrops().clear();
                event.getDrops().addAll(event.getState().getBlock().getDrops((IBlockAccess)event.getWorld(), event.getPos(), event.getState(), level));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LootingLevelEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().isPotionActive(BWRegistry.POTION_LOOTING)) {
            PotionEffect effect = event.getEntityLiving().getActivePotionEffect(BWRegistry.POTION_LOOTING);
            int level = effect.getAmplifier() + 1;
            if (event.getLootingLevel() < level) {
                event.setLootingLevel(level);
            }
        }
    }

    @SubscribeEvent
    public static void onPotionUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            for (PotionEffect potion : player.getActivePotionEffects()) {
                if (!(potion.getPotion() instanceof BWPotion)) continue;
                ((BWPotion)potion.getPotion()).tick((EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public static void saveSoup(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem().getItem() instanceof ItemSoup && event.getItem().getCount() > 0) {
            ItemStack result = event.getResultStack();
            event.setResultStack(event.getItem());
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                if (!player.inventory.addItemStackToInventory(result)) {
                    player.dropItem(result, false);
                }
            }
        }
    }
}

