/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeArmorDye
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private Ingredient validArmor;

    public RecipeArmorDye(Ingredient validArmor) {
        this.validArmor = validArmor;
        this.setRegistryName(new ResourceLocation("betterwithmods", "armor_dye"));
    }

    public boolean matches(InventoryCrafting inv, World worldIn) {
        ItemStack itemstack = ItemStack.EMPTY;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack itemstack1 = inv.getStackInSlot(i);
            if (itemstack1.isEmpty()) continue;
            if (this.validArmor.apply(itemstack1)) {
                itemstack = itemstack1;
                continue;
            }
            if (!DyeUtils.isDye((ItemStack)itemstack1)) {
                return false;
            }
            list.add(itemstack1);
        }
        return !itemstack.isEmpty() && !list.isEmpty();
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack itemstack = ItemStack.EMPTY;
        int[] aint = new int[3];
        int i = 0;
        int j = 0;
        ItemArmor itemarmor = null;
        for (int k = 0; k < inv.getSizeInventory(); ++k) {
            ItemStack itemstack1 = inv.getStackInSlot(k);
            if (itemstack1.isEmpty()) continue;
            if (itemstack1.getItem() instanceof ItemArmor) {
                itemarmor = (ItemArmor)itemstack1.getItem();
                if (!itemstack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                itemstack = itemstack1.copy();
                itemstack.setCount(1);
                if (!itemarmor.hasColor(itemstack1)) continue;
                int l = itemarmor.getColor(itemstack);
                float f = (float)(l >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(l & 0xFF) / 255.0f;
                i = (int)((float)i + Math.max(f, Math.max(f1, f2)) * 255.0f);
                aint[0] = (int)((float)aint[0] + f * 255.0f);
                aint[1] = (int)((float)aint[1] + f1 * 255.0f);
                aint[2] = (int)((float)aint[2] + f2 * 255.0f);
                ++j;
                continue;
            }
            if (!DyeUtils.isDye((ItemStack)itemstack1)) {
                return ItemStack.EMPTY;
            }
            float[] afloat = ((EnumDyeColor)DyeUtils.colorFromStack((ItemStack)itemstack1).get()).getColorComponentValues();
            int l1 = (int)(afloat[0] * 255.0f);
            int i2 = (int)(afloat[1] * 255.0f);
            int j2 = (int)(afloat[2] * 255.0f);
            i += Math.max(l1, Math.max(i2, j2));
            aint[0] = aint[0] + l1;
            aint[1] = aint[1] + i2;
            aint[2] = aint[2] + j2;
            ++j;
        }
        if (itemarmor == null) {
            return ItemStack.EMPTY;
        }
        int i1 = aint[0] / j;
        int j1 = aint[1] / j;
        int k1 = aint[2] / j;
        float f3 = (float)i / (float)j;
        float f4 = Math.max(i1, Math.max(j1, k1));
        i1 = (int)((float)i1 * f3 / f4);
        j1 = (int)((float)j1 * f3 / f4);
        k1 = (int)((float)k1 * f3 / f4);
        int k2 = (i1 << 8) + j1;
        k2 = (k2 << 8) + k1;
        itemarmor.setColor(itemstack, k2);
        return itemstack;
    }

    public ItemStack getRecipeOutput() {
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.getSizeInventory(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.getStackInSlot(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean canFit(int width, int height) {
        return width * height >= 2;
    }
}

