/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.bulk.manager;

import betterwithmods.common.registry.bulk.recipes.BulkRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CraftingManagerBulk<T extends BulkRecipe> {
    protected List<T> recipes = new ArrayList<T>();

    protected CraftingManagerBulk() {
    }

    public T addRecipe(T recipe) {
        if (!((BulkRecipe)recipe).isInvalid()) {
            this.recipes.add(recipe);
        }
        return recipe;
    }

    public abstract boolean craftRecipe(World var1, TileEntity var2, ItemStackHandler var3);

    @Nonnull
    public NonNullList<ItemStack> craftItem(T recipe, World world, TileEntity tile, ItemStackHandler inv) {
        return recipe != null ? ((BulkRecipe)recipe).onCraft(world, tile, inv) : NonNullList.create();
    }

    protected Optional<T> findRecipe(List<T> recipes, TileEntity tile, ItemStackHandler inv) {
        return recipes.stream().map(r -> {
            int i = r.matches(inv);
            return Pair.of((Object)r, (Object)i);
        }).filter(p -> (Integer)p.getValue() > -1).sorted(Comparator.comparingInt(Pair::getValue)).map(Pair::getKey).sorted().findFirst();
    }

    public T findRecipe(TileEntity tile, ItemStackHandler inv) {
        return (T)((BulkRecipe)this.findRecipe(this.recipes, tile, inv).orElse(null));
    }

    protected List<T> findRecipe(List<ItemStack> outputs) {
        List<T> recipes = this.findRecipeExact(outputs);
        if (recipes.isEmpty()) {
            recipes = this.findRecipeFuzzy(outputs);
        }
        return recipes;
    }

    protected List<T> findRecipeFuzzy(List<ItemStack> outputs) {
        return this.recipes.stream().filter(r -> r.getRecipeOutput().matchesFuzzy(outputs)).collect(Collectors.toList());
    }

    protected List<T> findRecipeExact(List<ItemStack> outputs) {
        return this.recipes.stream().filter(r -> r.getRecipeOutput().matches(outputs)).collect(Collectors.toList());
    }

    public boolean canCraft(T recipe, TileEntity tile, ItemStackHandler inv) {
        return recipe != null;
    }

    public T getRecipe(TileEntity tile, ItemStackHandler inv) {
        return (T)((BulkRecipe)this.findRecipe(this.recipes, tile, inv).orElse(null));
    }

    public List<T> getRecipes() {
        return this.recipes;
    }

    public boolean remove(T t) {
        return t != null && this.recipes.remove(t);
    }

    public boolean remove(List<ItemStack> outputs) {
        return this.recipes.removeAll(this.findRecipe(outputs));
    }

    public boolean removeFuzzy(List<ItemStack> outputs) {
        return this.recipes.removeAll(this.findRecipeFuzzy(outputs));
    }

    public boolean removeExact(List<ItemStack> outputs) {
        return this.recipes.removeAll(this.findRecipeExact(outputs));
    }
}

