/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry;

import betterwithmods.api.tile.IHopperFilter;
import betterwithmods.common.registry.HopperFilter;
import betterwithmods.common.registry.SelfHopperFilter;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class HopperFilters {
    private Map<String, IHopperFilter> FILTERS = Maps.newHashMap();

    public void addFilter(IHopperFilter filter) {
        this.FILTERS.put(filter.getName(), filter);
    }

    public IHopperFilter getFilter(String name) {
        return this.FILTERS.getOrDefault(name, HopperFilter.NONE);
    }

    public IHopperFilter getFilter(ItemStack stack) {
        if (stack.isEmpty()) {
            return HopperFilter.NONE;
        }
        return this.FILTERS.values().stream().filter(filter -> filter.getFilter().apply(stack)).findFirst().orElse(new SelfHopperFilter(stack));
    }
}

