/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry;

import betterwithmods.util.player.PlayerHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class BrokenToolRegistry {
    public static final Map<UUID, ItemStack> destroyed = new HashMap<UUID, ItemStack>();
    private static final Ticker ticker = new Ticker();

    public static void init() {
        MinecraftForge.EVENT_BUS.register(BrokenToolRegistry.class);
    }

    public static ItemStack findItem(EntityPlayer player, IBlockState state) {
        if (player == null) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = PlayerHelper.getHolding(player, player.getActiveHand());
        if (stack.isEmpty()) {
            return BrokenToolRegistry.getDestroyedItem(player);
        }
        return stack;
    }

    public static ItemStack getDestroyedItem(EntityPlayer player) {
        return destroyed.getOrDefault(player.getUniqueID(), ItemStack.EMPTY);
    }

    @SubscribeEvent
    public static void onPlayerDestroyItem(PlayerDestroyItemEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.getEntityWorld().isRemote || event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        ItemStack item = event.getOriginal();
        if (item.isEmpty()) {
            return;
        }
        destroyed.put(player.getUniqueID(), item);
        MinecraftForge.EVENT_BUS.register((Object)ticker);
    }

    public static class Ticker {
        @SubscribeEvent
        public void onTick(TickEvent.ServerTickEvent event) {
            destroyed.clear();
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

