/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.penalties;

import betterwithmods.common.penalties.Penalty;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;

public abstract class PenaltyHandler<T extends Number, P extends Penalty<T>> {
    protected List<P> penalties = Lists.newArrayList();
    private P defaultPenalty;

    public void addDefault(P defaultPenalty) {
        this.defaultPenalty = defaultPenalty;
        this.addPenalty(defaultPenalty);
    }

    public void addPenalty(P penalty) {
        this.penalties.add(penalty);
    }

    @Nonnull
    public P getPenalty(T t) {
        return (P)this.penalties.stream().filter(p -> p.inRange(t)).findFirst().orElse((Penalty)this.defaultPenalty);
    }

    public abstract P getPenalty(EntityPlayer var1);

    public P getMostSevere() {
        return (P)((Penalty)this.penalties.stream().max((a, b) -> Float.compare(a.getSeverity(), b.getSeverity())).orElse(null));
    }

    public boolean isDisplayed() {
        return true;
    }
}

