/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.items.tools;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.module.hardcore.creatures.HCEnchanting;
import betterwithmods.util.item.ToolsManager;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSoulforgedMattock
extends ItemTool {
    private static final Set<Block> EFFECTIVE = Sets.union(ToolsManager.getEffectiveBlocks((ItemTool)BWMItems.STEEL_PICKAXE), ToolsManager.getEffectiveBlocks((ItemTool)BWMItems.STEEL_SHOVEL));
    private static final Set<Material> EFFECTIVE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.ROCK, Material.IRON, Material.ANVIL, Material.GROUND, Material.GRASS, Material.CLAY, Material.GLASS, Material.PISTON, Material.SNOW});

    public ItemSoulforgedMattock() {
        super(BWMItems.SOULFORGED_STEEL, EFFECTIVE);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
    }

    public boolean getIsRepairable(ItemStack toRepair, ItemStack repair) {
        return BWOreDictionary.listContains(repair, (List<ItemStack>)OreDictionary.getOres((String)"ingotSoulforgedSteel")) || super.getIsRepairable(toRepair, repair);
    }

    public float getDestroySpeed(ItemStack stack, IBlockState state) {
        if (PlayerHelper.isCurrentToolEffectiveOnBlock(stack, state, EFFECTIVE_MATERIALS)) {
            return this.efficiency;
        }
        return EFFECTIVE.contains(state.getBlock()) ? this.efficiency : 1.0f;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"bwmmattock", (Object)"pickaxe", (Object)"shovel");
    }

    public boolean canHarvestBlock(IBlockState blockIn) {
        Block block = blockIn.getBlock();
        return this.toolMaterial.getHarvestLevel() >= block.getHarvestLevel(blockIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return HCEnchanting.canEnchantSteel(enchantment) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        return this.toolMaterial.getHarvestLevel();
    }
}

