/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.items.tools;

import betterwithmods.common.items.tools.ItemBroadheadArrow;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemCompositeBow
extends ItemBow {
    public ItemCompositeBow() {
        this.setMaxStackSize(1);
        this.setMaxDamage(576);
        this.addPropertyOverride(new ResourceLocation("pull"), (stack, worldIn, entityIn) -> {
            if (entityIn == null) {
                return 0.0f;
            }
            ItemStack itemstack = entityIn.getActiveItemStack();
            return !itemstack.isEmpty() && itemstack.getItem() == this ? (float)(stack.getMaxItemUseDuration() - entityIn.getItemInUseCount()) / 20.0f : 0.0f;
        });
        this.addPropertyOverride(new ResourceLocation("pulling"), (stack, worldIn, entityIn) -> entityIn != null && entityIn.isHandActive() && entityIn.getActiveItemStack() == stack ? 1.0f : 0.0f);
    }

    private boolean isBroadHead(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() instanceof ItemBroadheadArrow;
    }

    protected boolean isArrow(ItemStack stack) {
        return this.isBroadHead(stack) || super.isArrow(stack);
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isArrow(player.getHeldItem(EnumHand.OFF_HAND))) {
            return player.getHeldItem(EnumHand.OFF_HAND);
        }
        if (this.isArrow(player.getHeldItem(EnumHand.MAIN_HAND))) {
            return player.getHeldItem(EnumHand.MAIN_HAND);
        }
        IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack itemstack = inv.getStackInSlot(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public float getArrowVelocity(ItemStack stack, int charge) {
        int max = this.isBroadHead(stack) ? 2 : 1;
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > (float)max) {
            f = max;
        }
        return f;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            boolean flag = player.capabilities.isCreativeMode || EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.INFINITY, (ItemStack)stack) > 0;
            ItemStack itemstack = this.findAmmo(player);
            int i = this.getMaxItemUseDuration(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (!itemstack.isEmpty() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.isEmpty() || flag) {
                float velocity;
                if (itemstack.isEmpty()) {
                    itemstack = new ItemStack(Items.ARROW);
                }
                if ((double)(velocity = this.getArrowVelocity(itemstack, i)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = player.capabilities.isCreativeMode || itemstack.getItem() instanceof ItemArrow && ((ItemArrow)itemstack.getItem()).isInfinite(itemstack, stack, player);
                    if (!worldIn.isRemote) {
                        int k;
                        int j;
                        ItemArrow itemarrow = (ItemArrow)(itemstack.getItem() instanceof ItemArrow ? itemstack.getItem() : Items.ARROW);
                        EntityArrow entityarrow = itemarrow.createArrow(worldIn, itemstack, (EntityLivingBase)player);
                        entityarrow.shoot((Entity)player, player.rotationPitch, player.rotationYaw, 0.0f, velocity * 3.0f, 1.0f);
                        if (velocity >= 1.0f) {
                            entityarrow.setIsCritical(true);
                        }
                        if ((j = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.POWER, (ItemStack)stack)) > 0) {
                            entityarrow.setDamage(entityarrow.getDamage() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.PUNCH, (ItemStack)stack)) > 0) {
                            entityarrow.setKnockbackStrength(k);
                        }
                        if (EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.FLAME, (ItemStack)stack) > 0) {
                            entityarrow.setFire(100);
                        }
                        stack.damageItem(1, (EntityLivingBase)player);
                        if (flag1) {
                            entityarrow.pickupStatus = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.spawnEntity((Entity)entityarrow);
                    }
                    worldIn.playSound(null, player.posX, player.posY, player.posZ, SoundEvents.ENTITY_ARROW_SHOOT, SoundCategory.NEUTRAL, 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                    if (!flag1) {
                        itemstack.shrink(1);
                        if (itemstack.getCount() == 0) {
                            player.inventory.deleteStack(itemstack);
                        }
                    }
                    player.addStat(StatList.getObjectUseStats((Item)this));
                }
            }
        }
    }
}

