/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.items.tools;

import betterwithmods.api.client.IColorable;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.client.ColorHandlers;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class BWMArmor
extends ItemArmor
implements IColorable {
    private String name;

    public BWMArmor(ItemArmor.ArmorMaterial material, EntityEquipmentSlot equipmentSlotIn, String name) {
        super(material, 2, equipmentSlotIn);
        this.name = name;
        this.setCreativeTab(BWCreativeTabs.BWTAB);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return new ResourceLocation("betterwithmods", String.format("textures/models/armor/%s_layer_%s%s.png", this.name, this.armorType.getSlotIndex() == 2 ? "2" : "1", type != null ? "_" + type : "")).toString();
    }

    public int getColor(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.getTagCompound();
        if (nbttagcompound != null && nbttagcompound.hasKey("display") && (nbttagcompound1 = nbttagcompound.getCompoundTag("display")).hasKey("color", 3)) {
            return nbttagcompound1.getInteger("color");
        }
        return 0xFFFFFF;
    }

    public void removeColor(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.getTagCompound();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.getCompoundTag("display")).hasKey("color")) {
            nbttagcompound1.removeTag("color");
        }
    }

    public void setColor(ItemStack stack, int color) {
        NBTTagCompound nbttagcompound = stack.getTagCompound();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.setTagCompound(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("display");
        if (!nbttagcompound.hasKey("display", 10)) {
            nbttagcompound.setTag("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.setInteger("color", color);
    }

    public boolean hasColor(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.getTagCompound();
        return nbttagcompound != null && nbttagcompound.hasKey("display", 10) ? nbttagcompound.getCompoundTag("display").hasKey("color", 3) : false;
    }

    public boolean hasOverlay(ItemStack stack) {
        return this.getColor(stack) != 0xFFFFFF;
    }

    @Override
    public IItemColor getColorHandler() {
        return ColorHandlers.armor;
    }
}

