/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.items;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.entity.EntityDynamite;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemDynamite
extends Item {
    public ItemDynamite() {
        this.setCreativeTab(BWCreativeTabs.BWTAB);
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        int flintIndex = -1;
        for (int i = 0; i < player.inventory.mainInventory.size(); ++i) {
            if (((ItemStack)player.inventory.mainInventory.get(i)).isEmpty() || ((ItemStack)player.inventory.mainInventory.get(i)).getItem() != Items.FLINT_AND_STEEL) continue;
            flintIndex = i;
            break;
        }
        if (!world.isRemote) {
            boolean lit = false;
            if (flintIndex > -1) {
                lit = true;
                ItemStack steelStack = player.inventory.getStackInSlot(flintIndex);
                steelStack.damageItem(1, (EntityLivingBase)player);
                if (steelStack.getCount() < 1) {
                    player.inventory.mainInventory.set(flintIndex, (Object)ItemStack.EMPTY);
                }
            }
            player.getHeldItem(hand).shrink(1);
            EntityDynamite dynamite = new EntityDynamite(world, (EntityLivingBase)player, new ItemStack((Item)this, 1), lit);
            world.spawnEntity((Entity)dynamite);
            if (lit) {
                world.playSound(null, new BlockPos(dynamite.posX, dynamite.posY, dynamite.posZ), SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.AMBIENT, 1.0f, 1.0f);
            } else {
                world.playSound(null, new BlockPos(dynamite.posX, dynamite.posY, dynamite.posZ), SoundEvents.ENTITY_ARROW_SHOOT, SoundCategory.AMBIENT, 0.5f, 0.4f / (Item.itemRand.nextFloat() * 0.4f + 0.8f));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.getHeldItem(hand));
    }

    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.format((String)"lore.bwm:dynamite", (Object[])new Object[0]));
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return 6000;
    }
}

