/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.Vec3d;

public class EntityAIFlee
extends EntityAIBase {
    protected final double speed;
    private final EntityCreature theEntityCreature;
    private double randPosX;
    private double randPosY;
    private double randPosZ;

    public EntityAIFlee(EntityCreature creature, double speedIn) {
        this.theEntityCreature = creature;
        this.speed = speedIn;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        Vec3d vec3d = null;
        if (this.theEntityCreature.isBurning()) {
            vec3d = RandomPositionGenerator.findRandomTarget((EntityCreature)this.theEntityCreature, (int)5, (int)4);
        } else if (this.theEntityCreature.getRevengeTarget() != null) {
            vec3d = RandomPositionGenerator.findRandomTargetBlockAwayFrom((EntityCreature)this.theEntityCreature, (int)5, (int)0, (Vec3d)new Vec3d(this.theEntityCreature.getRevengeTarget().posX, this.theEntityCreature.getRevengeTarget().posY, this.theEntityCreature.getRevengeTarget().posZ));
        }
        if (vec3d != null) {
            this.randPosX = vec3d.x;
            this.randPosY = vec3d.y;
            this.randPosZ = vec3d.z;
            return true;
        }
        return false;
    }

    public void startExecuting() {
        this.theEntityCreature.getNavigator().tryMoveToXYZ(this.randPosX, this.randPosY, this.randPosZ, this.speed);
    }

    public boolean shouldContinueExecuting() {
        if (!this.theEntityCreature.getNavigator().noPath() && this.theEntityCreature.getRevengeTarget() != null) {
            double sqDistOfTargetToPos;
            double sqDistToTarget;
            EntityLivingBase target = this.theEntityCreature.getRevengeTarget();
            if (target == null) {
                return true;
            }
            double sqDistToPos = this.theEntityCreature.getDistanceSq(this.randPosX, this.randPosY, this.randPosZ);
            if (sqDistToPos > 2.0 && (sqDistToTarget = this.theEntityCreature.getDistanceSq((Entity)target)) < (sqDistOfTargetToPos = target.getDistanceSq(this.randPosX, this.randPosY, this.randPosZ))) {
                return true;
            }
        }
        return false;
    }
}

