/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class EntityAIEatFood
extends EntityAIBase {
    private EntityCreature entity;
    private Ingredient validItem;
    private EntityItem targetItem;
    private int cooldown;

    public EntityAIEatFood(EntityCreature creature, Ingredient validItem) {
        this.entity = creature;
        this.validItem = validItem;
    }

    public Optional<EntityItem> getTargetItem(List<EntityItem> items) {
        if (items.isEmpty()) {
            return Optional.empty();
        }
        EntityItem target = null;
        for (EntityItem item : items) {
            if (!this.validItem.test((Object)item.getItem())) continue;
            target = item;
            break;
        }
        return Optional.ofNullable(target);
    }

    public void resetTask() {
        this.targetItem = null;
    }

    public boolean shouldExecute() {
        if (this.cooldown > 0) {
            return false;
        }
        BlockPos entityPos = this.entity.getPosition();
        if (this.targetItem == null) {
            List entityItems = this.entity.getEntityWorld().getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.add(1, 1, 1)).expand(2.0, 2.0, 2.0));
            this.targetItem = this.getTargetItem(entityItems).orElse(null);
        }
        if (this.targetItem != null) {
            BlockPos targetPos = this.targetItem.getPosition();
            if (entityPos.getDistance(targetPos.getX(), targetPos.getY(), targetPos.getZ()) <= 2.0) {
                this.processItemEating();
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean shouldContinueExecuting() {
        return this.shouldExecute();
    }

    private void processItemEating() {
        if (this.targetItem != null) {
            ItemStack foodStack = this.targetItem.getItem().splitStack(1);
            this.entity.playSound(SoundEvents.ENTITY_PLAYER_BURP, 1.0f, (this.entity.world.rand.nextFloat() - this.entity.world.rand.nextFloat()) * 0.2f + 1.0f);
            foodStack.shrink(1);
            this.cooldown = 500;
        }
    }
}

