/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntitySpiderWeb
extends EntityThrowable {
    public EntitySpiderWeb(World worldIn) {
        super(worldIn);
    }

    public EntitySpiderWeb(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntitySpiderWeb(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    protected void onImpact(RayTraceResult result) {
        BlockPos pos = result.getBlockPos();
        if (pos == null || pos.getY() < 0 || pos.getY() >= 256) {
            return;
        }
        IBlockState state = this.world.getBlockState(pos);
        if (state.getMaterial().isReplaceable()) {
            this.world.setBlockState(pos, Blocks.WEB.getDefaultState());
            this.setDead();
        } else {
            BlockPos offset = pos.offset(result.sideHit);
            if (this.world.getBlockState(offset).getMaterial().isReplaceable()) {
                this.world.setBlockState(offset, Blocks.WEB.getDefaultState());
                this.setDead();
            }
        }
    }
}

