/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityMiningCharge
extends Entity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.createKey(EntityMiningCharge.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Integer> FACING = EntityDataManager.createKey(EntityMiningCharge.class, (DataSerializer)DataSerializers.VARINT);
    private EntityLivingBase igniter;
    private int fuse = 80;
    private EnumFacing facing;
    private HashMap<Block, IBlockState> dropMap = new HashMap<Block, IBlockState>(){
        {
            this.put(Blocks.COBBLESTONE, Blocks.GRAVEL.getDefaultState());
            this.put(Blocks.GRAVEL, Blocks.SAND.getDefaultState());
        }
    };

    public EntityMiningCharge(World worldIn) {
        super(worldIn);
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.98f);
    }

    public EntityMiningCharge(World worldIn, double x, double y, double z, EntityLivingBase igniter, EnumFacing facing) {
        this(worldIn);
        this.setFacing(facing);
        this.setPosition(x, y, z);
        this.setFuse(80);
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
        this.igniter = igniter;
        this.setNoGravity(facing != EnumFacing.UP);
    }

    protected void entityInit() {
        this.dataManager.register(FUSE, (Object)80);
        this.dataManager.register(FACING, (Object)EnumFacing.NORTH.getIndex());
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (!this.hasNoGravity()) {
            this.motionY -= (double)0.04f;
        }
        this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
        --this.fuse;
        if (this.fuse <= 0) {
            this.setDead();
            if (!this.getEntityWorld().isRemote) {
                this.explode();
            }
        } else {
            this.handleWaterMovement();
            this.getEntityWorld().spawnParticle(EnumParticleTypes.SMOKE_NORMAL, this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void explode() {
        this.getEntityWorld().playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_GENERIC_EXPLODE, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.getEntityWorld().rand.nextFloat() - this.getEntityWorld().rand.nextFloat()) * 0.2f) * 0.7f);
        this.getEntityWorld().spawnParticle(EnumParticleTypes.EXPLOSION_LARGE, this.posX, this.posY, this.posZ, 1.0, 0.0, 0.0, new int[0]);
        BlockPos pos = this.getPosition();
        EnumFacing facing = this.facing.getOpposite();
        for (int k = 0; k <= 3; ++k) {
            int dir;
            int n = dir = facing.getAxisDirection() == EnumFacing.AxisDirection.POSITIVE ? 1 : -1;
            if (k < 3) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                            this.explodeBlock(this.getEntityWorld(), pos.add(i, dir * k, j));
                            continue;
                        }
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            this.explodeBlock(this.getEntityWorld(), pos.add(i, j, dir * k));
                            continue;
                        }
                        if (facing != EnumFacing.EAST && facing != EnumFacing.WEST) continue;
                        this.explodeBlock(this.getEntityWorld(), pos.add(dir * k, i, j));
                    }
                }
                continue;
            }
            if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                this.explodeBlock(this.getEntityWorld(), pos.add(0, dir * k, 0));
                continue;
            }
            if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                this.explodeBlock(this.getEntityWorld(), pos.add(0, 0, dir * k));
                continue;
            }
            if (facing != EnumFacing.EAST && facing != EnumFacing.WEST) continue;
            this.explodeBlock(this.getEntityWorld(), pos.add(dir * k, 0, 0));
        }
        List entities = this.getEntityWorld().getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB(pos).expand(5.0, 5.0, 5.0));
        entities.forEach(entity -> entity.attackEntityFrom(DamageSource.causeExplosionDamage((EntityLivingBase)this.igniter), 45.0f));
    }

    private void explodeBlock(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        float resistance = state.getBlock().getExplosionResistance(world, pos, null, null);
        if (resistance < 100.0f) {
            Explosion explosion = new Explosion(world, (Entity)this.igniter, this.posX, this.posY, this.posZ, 0.0f, false, false);
            if (state.getBlock().canDropFromExplosion(explosion)) {
                if (this.dropMap.containsKey(state.getBlock())) {
                    IBlockState drop = this.dropMap.get(state.getBlock());
                    drop.getBlock().dropBlockAsItem(world, pos, drop, 0);
                } else {
                    state.getBlock().dropBlockAsItem(world, pos, state, 0);
                }
            }
            state.getBlock().onBlockExploded(world, pos, explosion);
            world.setBlockToAir(pos);
        }
    }

    protected void writeEntityToNBT(NBTTagCompound compound) {
        compound.setShort("Fuse", (short)this.getFuse());
        compound.setByte("Facing", (byte)this.getFacing().getIndex());
    }

    protected void readEntityFromNBT(NBTTagCompound compound) {
        this.setFuse(compound.getShort("Fuse"));
        this.setFacing(compound.getByte("Facing"));
    }

    public EntityLivingBase getTntPlacedBy() {
        return this.igniter;
    }

    public float getEyeHeight() {
        return 0.0f;
    }

    public void notifyDataManagerChange(DataParameter<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.getFuseDM();
        }
        if (FACING.equals(key)) {
            this.facing = EnumFacing.getFront((int)this.getFacingDM());
        }
    }

    public void setFacing(EnumFacing facing) {
        this.dataManager.set(FACING, (Object)facing.getIndex());
        this.facing = facing;
    }

    public int getFuseDM() {
        return (Integer)this.dataManager.get(FUSE);
    }

    public int getFacingDM() {
        return (Integer)this.dataManager.get(FACING);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(int facing) {
        this.setFacing(EnumFacing.getFront((int)facing));
    }

    public int getFuse() {
        return this.fuse;
    }

    public void setFuse(int fuseIn) {
        this.dataManager.set(FUSE, (Object)fuseIn);
        this.fuse = fuseIn;
    }
}

