/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityFallingGourd
extends EntityFallingBlock {
    private static final DataParameter<Integer> FALLBLOCK = EntityDataManager.createKey(EntityFallingGourd.class, (DataSerializer)DataSerializers.VARINT);
    private ItemStack seedStack = ItemStack.EMPTY;
    private SoundEvent shatterSound = SoundEvents.ENTITY_SLIME_SQUISH;
    private boolean smashOnImpact = false;

    public EntityFallingGourd(World worldIn) {
        super(worldIn);
    }

    public EntityFallingGourd(World worldIn, double x, double y, double z, IBlockState fallingBlockState) {
        super(worldIn, x, y, z, fallingBlockState);
        this.setBlock(fallingBlockState);
    }

    public void onUpdate() {
        IBlockState fallblock = this.getBlock();
        Block block = fallblock.getBlock();
        if (fallblock.getMaterial() == Material.AIR) {
            this.setDead();
        } else {
            BlockPos blockpos1;
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            if (this.fallTime++ == 0) {
                blockpos1 = new BlockPos((Entity)this);
                if (this.getEntityWorld().getBlockState(blockpos1).getBlock() == block) {
                    this.getEntityWorld().setBlockToAir(blockpos1);
                } else if (!this.getEntityWorld().isRemote) {
                    this.setDead();
                    return;
                }
            }
            if (!this.hasNoGravity()) {
                this.motionY -= (double)0.04f;
            }
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.98f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)0.98f;
            if (!this.getEntityWorld().isRemote) {
                blockpos1 = new BlockPos((Entity)this);
                if (this.onGround) {
                    IBlockState iblockstate = this.world.getBlockState(blockpos1);
                    if (this.world.isAirBlock(new BlockPos(this.posX, this.posY - (double)0.01f, this.posZ)) && BlockFalling.canFallThrough((IBlockState)this.getEntityWorld().getBlockState(new BlockPos(this.posX, this.posY - 0.01, this.posZ)))) {
                        this.onGround = false;
                        return;
                    }
                    this.motionX *= 0.7;
                    this.motionZ *= 0.7;
                    this.motionY *= -0.5;
                    if (10 + this.rand.nextInt(7) <= this.fallTime) {
                        this.smashOnImpact = true;
                    }
                    if (iblockstate.getBlock() != Blocks.PISTON_EXTENSION) {
                        if (!this.smashOnImpact && this.getEntityWorld().mayPlace(block, blockpos1, true, EnumFacing.UP, null) && !BlockFalling.canFallThrough((IBlockState)this.getEntityWorld().getBlockState(blockpos1.down())) && this.getEntityWorld().setBlockState(blockpos1, fallblock, 3)) {
                            this.setDead();
                            if (block instanceof BlockFalling) {
                                ((BlockFalling)block).onEndFalling(this.getEntityWorld(), blockpos1, fallblock, iblockstate);
                            }
                        } else {
                            this.shatter();
                        }
                    }
                }
            }
        }
    }

    public void fall(float distance, float damageMultiplier) {
        int i = MathHelper.ceil((float)(distance - 1.0f));
        if (i > 0 && !this.world.isRemote) {
            ArrayList list = Lists.newArrayList((Iterable)this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.getEntityBoundingBox()));
            for (Entity entity : list) {
                entity.attackEntityFrom(DamageSource.FALLING_BLOCK, 1.0f);
                this.smashOnImpact = true;
            }
        }
    }

    public void shatter() {
        if (!this.getEntityWorld().isRemote) {
            this.playSound(this.shatterSound, 0.8f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            IBlockState fallblock = this.getBlock();
            if (fallblock != null) {
                this.getEntityWorld().playEvent(2001, new BlockPos((Entity)this), Block.getStateId((IBlockState)fallblock));
            }
            if (!this.seedStack.isEmpty()) {
                ItemStack seeds = this.seedStack.copy();
                seeds.setCount(this.rand.nextInt(3) + 1);
                if (this.shouldDropItem && this.getEntityWorld().getGameRules().getBoolean("doEntityDrops")) {
                    this.entityDropItem(seeds, 0.0f);
                }
            }
            this.setDead();
        }
    }

    @Nullable
    public IBlockState getBlock() {
        return Block.getStateById((int)((Integer)this.dataManager.get(FALLBLOCK)));
    }

    public void setBlock(IBlockState blockstate) {
        this.dataManager.set(FALLBLOCK, (Object)Block.getStateId((IBlockState)blockstate));
    }

    public ItemStack getSeedStack() {
        return this.seedStack;
    }

    public void setSeedStack(ItemStack stack) {
        this.seedStack = stack;
    }

    public void setShatterSound(SoundEvent sound) {
        this.shatterSound = sound;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(FALLBLOCK, (Object)0);
    }

    public void readEntityFromNBT(NBTTagCompound tagCompound) {
        super.readEntityFromNBT(tagCompound);
        this.setBlock(this.fallTile);
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        this.fallTile = this.getBlock();
        super.writeEntityToNBT(compound);
    }
}

